/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppResourceDataStructureEntity;
import com.ejianc.business.cefoc.asip.bean.AppResourceDataStructureParamEntity;
import com.ejianc.business.cefoc.asip.service.IAppResourceDataStructureService;
import com.ejianc.business.cefoc.asip.vo.AppResourceDataStructureParamVO;
import com.ejianc.business.cefoc.asip.vo.AppResourceDataStructureVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"appResourceDataStructure"})
public class AppResourceDataStructureController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAppResourceDataStructureService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AppResourceDataStructureVO> saveOrUpdate(@RequestBody AppResourceDataStructureVO saveOrUpdateVO) {
        AppResourceDataStructureEntity entity = (AppResourceDataStructureEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AppResourceDataStructureEntity.class));
        if (entity.getId() != null) {
            entity = (AppResourceDataStructureEntity)((Object)this.service.selectById(entity.getId()));
            entity.setDataStructureName(saveOrUpdateVO.getDataStructureName());
            entity.setDataStructureIdentification(saveOrUpdateVO.getDataStructureIdentification());
            entity.setDataStructureDescribe(saveOrUpdateVO.getDataStructureDescribe());
            if (saveOrUpdateVO.getParamList() != null && saveOrUpdateVO.getParamList().size() > 0) {
                List<AppResourceDataStructureParamEntity> paramList = new ArrayList<AppResourceDataStructureParamEntity>();
                paramList = this.dealChildren(saveOrUpdateVO.getParamList(), paramList, null);
                entity.setParamList(paramList);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        AppResourceDataStructureVO vo = (AppResourceDataStructureVO)BeanMapper.map((Object)((Object)entity), AppResourceDataStructureVO.class);
        List<AppResourceDataStructureParamVO> detailVOS = this.createTreeData(vo.getParamList());
        vo.setParamList(detailVOS);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private List<AppResourceDataStructureParamEntity> dealChildren(List<AppResourceDataStructureParamVO> children, List<AppResourceDataStructureParamEntity> paramList, Long pid) {
        for (AppResourceDataStructureParamVO param : children) {
            param.setPid(pid);
            if ("add".equals(param.getRowState())) {
                param.setId(Long.valueOf(IdWorker.getId()));
            }
            if (param.getChildren() != null && param.getChildren().size() > 0) {
                paramList = this.dealChildren(param.getChildren(), paramList, param.getId());
            }
            AppResourceDataStructureParamEntity en = (AppResourceDataStructureParamEntity)((Object)BeanMapper.map((Object)param, AppResourceDataStructureParamEntity.class));
            paramList.add(en);
        }
        return paramList;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AppResourceDataStructureVO> queryDetail(Long id) {
        AppResourceDataStructureEntity entity = (AppResourceDataStructureEntity)((Object)this.service.selectById(id));
        AppResourceDataStructureVO vo = (AppResourceDataStructureVO)BeanMapper.map((Object)((Object)entity), AppResourceDataStructureVO.class);
        List<AppResourceDataStructureParamVO> detailVOS = this.createTreeData(vo.getParamList());
        vo.setParamList(detailVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private List<AppResourceDataStructureParamVO> createTreeData(List<AppResourceDataStructureParamVO> list) {
        ArrayList<AppResourceDataStructureParamVO> resp = new ArrayList<AppResourceDataStructureParamVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, AppResourceDataStructureParamVO> listMap = new HashMap<String, AppResourceDataStructureParamVO>();
        for (AppResourceDataStructureParamVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            AppResourceDataStructureParamVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            AppResourceDataStructureParamVO parent = (AppResourceDataStructureParamVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<AppResourceDataStructureParamVO> children = new ArrayList<AppResourceDataStructureParamVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((AppResourceDataStructureParamVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AppResourceDataStructureVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("dataStructureName");
        fuzzyFields.add("dataStructureIdentification");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AppResourceDataStructureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AppResourceDataStructureVO>> queryAllList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List data = this.service.queryList(param, false);
        List list = new ArrayList();
        if (data != null && data.size() > 0) {
            list = BeanMapper.mapList((Iterable)data, AppResourceDataStructureVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/refDataStructureList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AppResourceDataStructureVO>> refDataStructureList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AppResourceDataStructureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

