/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cefoc.asip.bean.AppAuthEntity;
import com.ejianc.business.cefoc.asip.bean.AppAuthReqParamEntity;
import com.ejianc.business.cefoc.asip.bean.AppReqEntity;
import com.ejianc.business.cefoc.asip.mapper.AppAuthMapper;
import com.ejianc.business.cefoc.asip.service.IAppAuthReqParamService;
import com.ejianc.business.cefoc.asip.service.IAppAuthService;
import com.ejianc.business.cefoc.asip.service.IAppReqService;
import com.ejianc.business.cefoc.asip.service.IInterfaceHandlerService;
import com.ejianc.business.cefoc.asip.vo.AppAuthReqParamVO;
import com.ejianc.business.cefoc.asip.vo.AppAuthVO;
import com.ejianc.business.cefoc.asip.vo.AppReqVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appAuthService")
public class AppAuthServiceImpl
extends BaseServiceImpl<AppAuthMapper, AppAuthEntity>
implements IAppAuthService {
    @Autowired
    private IAppAuthReqParamService appAuthReqParamService;
    @Autowired
    private IAppReqService appReqService;
    @Autowired
    private IInterfaceHandlerService interfaceHandlerService;

    @Override
    public AppAuthVO queryDetailByAppId(Long appId, String type) {
        AppAuthVO vo = null;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"app_id", (Object)appId);
        wrapper.eq((Object)"type", (Object)type);
        AppAuthEntity entity = (AppAuthEntity)((Object)this.getOne((Wrapper)wrapper));
        if (entity != null) {
            vo = (AppAuthVO)BeanMapper.map((Object)((Object)entity), AppAuthVO.class);
            QueryWrapper configWrapper = new QueryWrapper();
            configWrapper.eq((Object)"auth_id", (Object)entity.getId());
            List configList = this.appAuthReqParamService.list((Wrapper)configWrapper);
            ArrayList<Object> headerSetReqList = new ArrayList<Object>();
            ArrayList<Object> bodySetReqList = new ArrayList<Object>();
            ArrayList<Object> urlParamSetReqList = new ArrayList<Object>();
            if (configList != null && configList.size() > 0) {
                for (AppAuthReqParamEntity item : configList) {
                    if ("header".equals(item.getType())) {
                        headerSetReqList.add(BeanMapper.map((Object)((Object)item), AppAuthReqParamVO.class));
                        continue;
                    }
                    if ("body".equals(item.getType())) {
                        bodySetReqList.add(BeanMapper.map((Object)((Object)item), AppAuthReqParamVO.class));
                        continue;
                    }
                    if (!"urlParam".equals(item.getType())) continue;
                    urlParamSetReqList.add(BeanMapper.map((Object)((Object)item), AppAuthReqParamVO.class));
                }
            }
            vo.setHeaderSetReqList(headerSetReqList);
            vo.setBodySetReqList(bodySetReqList);
            vo.setUrlParamSetReqList(urlParamSetReqList);
            ArrayList<Object> headerReqList = new ArrayList<Object>();
            ArrayList<AppReqVO> bodyReqList = new ArrayList<AppReqVO>();
            ArrayList<Object> urlParamReqList = new ArrayList<Object>();
            QueryWrapper reqWrapper = new QueryWrapper();
            reqWrapper.eq((Object)"req_id", (Object)entity.getId());
            List reqList = this.appReqService.list((Wrapper)reqWrapper);
            if (reqList != null && reqList.size() > 0) {
                for (AppReqEntity item : reqList) {
                    if ("header".equals(item.getType())) {
                        headerReqList.add(BeanMapper.map((Object)((Object)item), AppReqVO.class));
                        continue;
                    }
                    if ("body".equals(item.getType())) {
                        bodyReqList.add((AppReqVO)BeanMapper.map((Object)((Object)item), AppReqVO.class));
                        continue;
                    }
                    if (!"urlParam".equals(item.getType())) continue;
                    urlParamReqList.add(BeanMapper.map((Object)((Object)item), AppReqVO.class));
                }
            }
            vo.setHeaderReqList(headerReqList);
            List<AppReqVO> detailVOS = this.createTreeData(bodyReqList);
            vo.setBodyReqList(detailVOS);
            vo.setUrlParamReqList(urlParamReqList);
        }
        return vo;
    }

    @Override
    public AppAuthVO saveData(AppAuthVO saveOrUpdateVO) {
        AppAuthEntity entity = (AppAuthEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AppAuthEntity.class));
        if (saveOrUpdateVO.getId() != null) {
            AppAuthEntity old = (AppAuthEntity)((Object)this.selectById(saveOrUpdateVO.getId()));
            entity.setCreateTime(old.getCreateTime());
            entity.setCreateUserCode(old.getCreateUserCode());
            entity.setTenantId(old.getTenantId());
            entity.setVersion(old.getVersion());
            if (!entity.getAuthType().equals(old.getAuthType())) {
                QueryWrapper configWrapper = new QueryWrapper();
                configWrapper.eq((Object)"auth_id", (Object)entity.getId());
                this.appAuthReqParamService.remove((Wrapper)configWrapper);
                QueryWrapper reqWrapper = new QueryWrapper();
                reqWrapper.eq((Object)"req_id", (Object)entity.getId());
                this.appReqService.remove((Wrapper)reqWrapper);
            }
        }
        if ("none".equals(entity.getAuthType())) {
            entity.setAddress(null);
            entity.setMode(null);
            entity.setRequestBodyFormat(null);
            entity.setWebWsdlAddress(null);
            entity.setWebService(null);
            entity.setWebPort(null);
            entity.setWebOperation(null);
            entity.setWebAddress(null);
        } else {
            if ("http".equals(entity.getType())) {
                entity.setWebWsdlAddress(null);
                entity.setWebService(null);
                entity.setWebPort(null);
                entity.setWebOperation(null);
                entity.setWebAddress(null);
            } else if ("webService".equals(entity.getType())) {
                entity.setAddress(null);
                entity.setMode(null);
                entity.setRequestBodyFormat(null);
            }
            List<AppAuthReqParamEntity> appAuthReqParamList = new ArrayList<AppAuthReqParamEntity>();
            if (saveOrUpdateVO.getHeaderSetReqList() != null && saveOrUpdateVO.getHeaderSetReqList().size() > 0) {
                appAuthReqParamList = BeanMapper.mapList((Iterable)saveOrUpdateVO.getHeaderSetReqList(), AppAuthReqParamEntity.class);
            }
            if (saveOrUpdateVO.getBodySetReqList() != null && saveOrUpdateVO.getBodySetReqList().size() > 0) {
                appAuthReqParamList.addAll(BeanMapper.mapList((Iterable)saveOrUpdateVO.getBodySetReqList(), AppAuthReqParamEntity.class));
            }
            if (saveOrUpdateVO.getUrlParamSetReqList() != null && saveOrUpdateVO.getUrlParamSetReqList().size() > 0) {
                appAuthReqParamList.addAll(BeanMapper.mapList((Iterable)saveOrUpdateVO.getUrlParamSetReqList(), AppAuthReqParamEntity.class));
            }
            entity.setAppAuthReqParamList(appAuthReqParamList);
            List<AppReqEntity> appReqList = new ArrayList<AppReqEntity>();
            if (saveOrUpdateVO.getHeaderReqList() != null && saveOrUpdateVO.getHeaderReqList().size() > 0) {
                appReqList = BeanMapper.mapList((Iterable)saveOrUpdateVO.getHeaderReqList(), AppReqEntity.class);
            }
            if (saveOrUpdateVO.getBodyReqList() != null && saveOrUpdateVO.getBodyReqList().size() > 0) {
                List<AppReqEntity> paramList = new ArrayList<AppReqEntity>();
                paramList = this.dealChildren(saveOrUpdateVO.getBodyReqList(), paramList, null, "body");
                appReqList.addAll(paramList);
            }
            if (saveOrUpdateVO.getUrlParamReqList() != null && saveOrUpdateVO.getUrlParamReqList().size() > 0) {
                appReqList.addAll(BeanMapper.mapList((Iterable)saveOrUpdateVO.getUrlParamReqList(), AppReqEntity.class));
            }
            entity.setAppReqList(appReqList);
        }
        this.saveOrUpdate((Object)entity, false);
        AppAuthVO vo = (AppAuthVO)BeanMapper.map((Object)((Object)entity), AppAuthVO.class);
        return vo;
    }

    private List<AppReqEntity> dealChildren(List<AppReqVO> children, List<AppReqEntity> paramList, Long pid, String type) {
        for (AppReqVO param : children) {
            param.setPid(pid);
            if ("add".equals(param.getRowState())) {
                param.setId(Long.valueOf(IdWorker.getId()));
            }
            if (param.getChildren() != null && param.getChildren().size() > 0) {
                paramList = this.dealChildren(param.getChildren(), paramList, param.getId(), type);
            }
            AppReqEntity en = (AppReqEntity)((Object)BeanMapper.map((Object)param, AppReqEntity.class));
            en.setType(type);
            paramList.add(en);
        }
        return paramList;
    }

    private List<AppReqVO> createTreeData(List<AppReqVO> list) {
        ArrayList<AppReqVO> resp = new ArrayList<AppReqVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, AppReqVO> listMap = new HashMap<String, AppReqVO>();
        for (AppReqVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            AppReqVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            AppReqVO parent = (AppReqVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<AppReqVO> children = new ArrayList<AppReqVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((AppReqVO)listMap.get(rootId));
        }
        return resp;
    }

    @Override
    public JSONObject verifyToken(AppAuthVO vo) {
        JSONObject json = new JSONObject();
        if (StringUtils.isBlank((CharSequence)vo.getMode())) {
            throw new BusinessException("\u8bf7\u6c42\u7c7b\u578b\u672a\u8bbe\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)vo.getAddress())) {
            throw new BusinessException("\u8bf7\u6c42\u5730\u5740\u672a\u8bbe\u7f6e");
        }
        JSONObject param = new JSONObject();
        if ("GET".equals(vo.getMode())) {
            if (vo.getUrlParamReqList() != null && vo.getUrlParamReqList().size() > 0) {
                for (AppReqVO header : vo.getUrlParamReqList()) {
                    param.put(header.getParamName(), (Object)header.getParamValue());
                }
            }
        } else if ("json".equals(vo.getRequestBodyFormat())) {
            if (vo.getBodyReqList() != null && vo.getBodyReqList().size() > 0) {
                param = this.dealJsonParam(param, vo.getBodyReqList());
            }
        } else if ("form".equals(vo.getRequestBodyFormat()) && vo.getBodyReqList() != null && vo.getBodyReqList().size() > 0) {
            for (AppReqVO header : vo.getBodyReqList()) {
                param.put(header.getParamName(), (Object)header.getParamValue());
            }
        }
        CommonResponse<JSONObject> result = this.interfaceHandlerService.getAuthResult(vo, false);
        json.put("param", (Object)param);
        json.put("result", result.getData());
        return json;
    }

    @Override
    public AppAuthVO queryDetail(Long id) {
        AppAuthEntity entity = (AppAuthEntity)((Object)this.selectById(id));
        AppAuthVO vo = (AppAuthVO)BeanMapper.map((Object)((Object)entity), AppAuthVO.class);
        QueryWrapper configWrapper = new QueryWrapper();
        configWrapper.eq((Object)"auth_id", (Object)entity.getId());
        List configList = this.appAuthReqParamService.list((Wrapper)configWrapper);
        ArrayList<Object> headerSetReqList = new ArrayList<Object>();
        ArrayList<Object> bodySetReqList = new ArrayList<Object>();
        ArrayList<Object> urlParamSetReqList = new ArrayList<Object>();
        if (configList != null && configList.size() > 0) {
            for (AppAuthReqParamEntity item : configList) {
                if ("header".equals(item.getType())) {
                    headerSetReqList.add(BeanMapper.map((Object)((Object)item), AppAuthReqParamVO.class));
                    continue;
                }
                if ("body".equals(item.getType())) {
                    bodySetReqList.add(BeanMapper.map((Object)((Object)item), AppAuthReqParamVO.class));
                    continue;
                }
                if (!"urlParam".equals(item.getType())) continue;
                urlParamSetReqList.add(BeanMapper.map((Object)((Object)item), AppAuthReqParamVO.class));
            }
        }
        vo.setHeaderSetReqList(headerSetReqList);
        vo.setBodySetReqList(bodySetReqList);
        vo.setUrlParamSetReqList(urlParamSetReqList);
        ArrayList<Object> headerReqList = new ArrayList<Object>();
        ArrayList<AppReqVO> bodyReqList = new ArrayList<AppReqVO>();
        ArrayList<Object> urlParamReqList = new ArrayList<Object>();
        QueryWrapper reqWrapper = new QueryWrapper();
        reqWrapper.eq((Object)"req_id", (Object)entity.getId());
        List reqList = this.appReqService.list((Wrapper)reqWrapper);
        if (reqList != null && reqList.size() > 0) {
            for (AppReqEntity item : reqList) {
                if ("header".equals(item.getType())) {
                    headerReqList.add(BeanMapper.map((Object)((Object)item), AppReqVO.class));
                    continue;
                }
                if ("body".equals(item.getType())) {
                    bodyReqList.add((AppReqVO)BeanMapper.map((Object)((Object)item), AppReqVO.class));
                    continue;
                }
                if (!"urlParam".equals(item.getType())) continue;
                urlParamReqList.add(BeanMapper.map((Object)((Object)item), AppReqVO.class));
            }
        }
        vo.setHeaderReqList(headerReqList);
        List<AppReqVO> detailVOS = this.createTreeData(bodyReqList);
        vo.setBodyReqList(detailVOS);
        vo.setUrlParamReqList(urlParamReqList);
        return vo;
    }

    private JSONObject dealJsonParam(JSONObject data, List<AppReqVO> children) {
        for (AppReqVO child : children) {
            if (child.getChildren() != null && child.getChildren().size() > 0) {
                JSONObject ch = new JSONObject();
                ch = this.dealJsonParam(ch, child.getChildren());
                data.put(child.getParamName(), (Object)ch);
                continue;
            }
            data.put(child.getParamName(), (Object)child.getParamValue());
        }
        return data;
    }
}

