/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.ownrmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.ownrmat.bean.AmortizationEntity;
import com.ejianc.business.assist.ownrmat.mapper.AmortizationMapper;
import com.ejianc.business.assist.ownrmat.service.IAmortizationService;
import com.ejianc.business.assist.ownrmat.vo.AmortizationVO;
import com.ejianc.business.assist.ownrmat.vo.ResidualVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="amortizationService")
public class AmortizationServiceImpl
extends BaseServiceImpl<AmortizationMapper, AmortizationEntity>
implements IAmortizationService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public Boolean saveOrUpdate(AmortizationVO saveOrUpdateVO) {
        Long orgId = InvocationInfoProxy.getOrgId();
        Long tenantid = InvocationInfoProxy.getTenantid();
        saveOrUpdateVO.setTenantId(tenantid);
        String orgCode = this.sessionManager.getUserContext().getOrgCode();
        String orgName = this.sessionManager.getUserContext().getOrgName();
        if (saveOrUpdateVO.getAmortizationStatus() == 1) {
            Integer rowType = saveOrUpdateVO.getRowType();
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(AmortizationEntity::getAmortizationStatus, (Object)1);
            lambd.eq(AmortizationEntity::getRowType, (Object)rowType);
            if (rowType == 1) {
                lambd.eq(AmortizationEntity::getMaterialTypeId, (Object)saveOrUpdateVO.getMaterialTypeId());
            } else {
                lambd.eq(AmortizationEntity::getMaterialId, (Object)saveOrUpdateVO.getMaterialId());
            }
            if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
                lambd.eq(AmortizationEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
                lambd.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            } else {
                lambd.eq(AmortizationEntity::getOrgId, (Object)orgId);
            }
            List list = super.list((Wrapper)lambd);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                if (rowType == 1) {
                    throw new BusinessException(saveOrUpdateVO.getMaterialTypeName() + "(\u6750\u6599\u5206\u7c7b)\u5df2\u6709\u542f\u7528\u8bbe\u7f6e\uff0c\u8bf7\u5173\u95ed\u540e\u518d\u6dfb\u52a0\u542f\u7528\u8bbe\u7f6e\u3002");
                }
                throw new BusinessException(saveOrUpdateVO.getMaterialName() + "(\u6750\u6599)\u5df2\u6709\u542f\u7528\u8bbe\u7f6e\uff0c\u8bf7\u5173\u95ed\u540e\u518d\u6dfb\u52a0\u542f\u7528\u8bbe\u7f6e\u3002");
            }
        }
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() <= 0L) {
            saveOrUpdateVO.setOrgId(orgId);
            saveOrUpdateVO.setOrgCode(orgCode);
            saveOrUpdateVO.setOrgName(orgName);
        }
        AmortizationEntity entity = (AmortizationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AmortizationEntity.class));
        return super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public String turnSwitch(AmortizationVO vo) {
        if (vo.getAmortizationStatus() == 0) {
            LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
            lambd.set(AmortizationEntity::getAmortizationStatus, (Object)0);
            lambd.eq(BaseEntity::getId, (Object)vo.getId());
            super.update((Wrapper)lambd);
            return "\u505c\u7528\u6210\u529f\uff01";
        }
        Integer rowType = vo.getRowType();
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(AmortizationEntity::getAmortizationStatus, (Object)0);
        lambd.eq(AmortizationEntity::getAmortizationStatus, (Object)1);
        lambd.eq(AmortizationEntity::getOrgId, (Object)vo.getOrgId());
        if (rowType == 1) {
            lambd.eq(AmortizationEntity::getMaterialTypeId, (Object)vo.getMaterialTypeId());
        } else {
            lambd.eq(AmortizationEntity::getMaterialId, (Object)vo.getMaterialId());
        }
        lambd.ne(BaseEntity::getId, (Object)vo.getId());
        super.update((Wrapper)lambd);
        LambdaUpdateWrapper lambdUpdate = new LambdaUpdateWrapper();
        lambdUpdate.set(AmortizationEntity::getAmortizationStatus, (Object)1);
        lambdUpdate.eq(BaseEntity::getId, (Object)vo.getId());
        super.update((Wrapper)lambdUpdate);
        return "\u542f\u7528\u6210\u529f\uff01";
    }

    @Override
    public Map<Long, AmortizationEntity> getResidualRate(ResidualVO vo) {
        Map<Long, AmortizationEntity> rateMap = this.getResidualRateByOrgId(vo);
        return rateMap;
    }

    private Map<Long, AmortizationEntity> getResidualRateByOrgId(ResidualVO vo) {
        Long orgId = vo.getOrgId();
        List materialIds = vo.getMaterialIds();
        if (CollectionUtils.isEmpty((Collection)materialIds)) {
            return new HashMap<Long, AmortizationEntity>();
        }
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(AmortizationEntity::getOrgId, (Object)orgId);
        lambd.eq(AmortizationEntity::getAmortizationStatus, (Object)1);
        List list = super.list((Wrapper)lambd);
        HashMap<Long, AmortizationEntity> map = new HashMap<Long, AmortizationEntity>();
        ArrayList<AmortizationEntity> typeList = new ArrayList<AmortizationEntity>();
        for (AmortizationEntity entity : list) {
            if (entity.getRowType() == 2 && materialIds.size() > 0) {
                if (!materialIds.contains(entity.getMaterialId())) continue;
                map.put(entity.getMaterialId(), entity);
                materialIds.remove(entity.getMaterialId());
                continue;
            }
            typeList.add(entity);
        }
        if (materialIds.size() == 0) {
            return map;
        }
        if (CollectionUtils.isEmpty(typeList)) {
            OrgVO parentsVo = (OrgVO)this.orgApi.detailById(orgId).getData();
            if (parentsVo.getParentId() != null && parentsVo.getParentId() > 0L) {
                ResidualVO residualVO = new ResidualVO();
                residualVO.setOrgId(parentsVo.getParentId());
                residualVO.setMaterialIds(materialIds);
                Map<Long, AmortizationEntity> resMap = this.getResidualRateByOrgId(residualVO);
                map.putAll(resMap);
            }
            return map;
        }
        CommonResponse mapCommonResponse = this.shareMaterialApi.queryCategoryListByMaterialId(materialIds);
        if (!mapCommonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6750\u6599\u4e0a\u7ea7\u5206\u7c7b\u5931\u8d25");
        }
        Map dataMap = (Map)mapCommonResponse.getData();
        Map<Long, AmortizationEntity> residualRateMap = this.getResidualRateByCategory(typeList, dataMap);
        map.putAll(residualRateMap);
        if (residualRateMap.size() != materialIds.size()) {
            OrgVO parentsVo = (OrgVO)this.orgApi.detailById(orgId).getData();
            if (parentsVo.getParentId() != null && parentsVo.getParentId() > 0L) {
                ResidualVO residualVO = new ResidualVO();
                residualVO.setOrgId(parentsVo.getParentId());
                ArrayList<Long> matIds = new ArrayList<Long>();
                for (Long matId : materialIds) {
                    matIds.add(matId);
                }
                for (Long mid : residualRateMap.keySet()) {
                    if (!matIds.contains(mid)) continue;
                    matIds.remove(mid);
                }
                residualVO.setMaterialIds(matIds);
                Map<Long, AmortizationEntity> resMap = this.getResidualRateByOrgId(residualVO);
                map.putAll(resMap);
            }
            return map;
        }
        return map;
    }

    private Map<Long, AmortizationEntity> getResidualRateByCategory(List<AmortizationEntity> typeList, Map<Long, List<MaterialCategoryVO>> dataMap) {
        HashMap<Long, AmortizationEntity> resMap = new HashMap<Long, AmortizationEntity>();
        HashMap<Long, AmortizationEntity> typeMap = new HashMap<Long, AmortizationEntity>();
        for (AmortizationEntity entity : typeList) {
            typeMap.put(entity.getMaterialTypeId(), entity);
        }
        block1: for (Long materialId : dataMap.keySet()) {
            List<MaterialCategoryVO> materialCategoryVOS = dataMap.get(materialId);
            for (MaterialCategoryVO vo : materialCategoryVOS) {
                if (!typeMap.containsKey(vo.getId())) continue;
                resMap.put(materialId, (AmortizationEntity)((Object)typeMap.get(vo.getId())));
                continue block1;
            }
        }
        return resMap;
    }
}

