/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.material.bean.MaterialDeliveryEntity;
import com.ejianc.business.assist.material.service.IMaterialDeliveryService;
import com.ejianc.business.assist.material.utils.EntityUtil;
import com.ejianc.business.assist.material.vo.MaterialDeliveryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialDelivery"})
public class MaterialDeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialDeliveryService service;
    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value={"billSync"})
    @ResponseBody
    public CommonResponse<String> billSync(HttpServletRequest request) {
        String msg = this.service.saveSyncBill(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    @PostMapping(value={"billDel"})
    @ResponseBody
    public CommonResponse<String> billDel(@RequestBody MaterialDeliveryVO vo) {
        MaterialDeliveryEntity entity = EntityUtil.selectOne("source_id", vo.getSourceId(), MaterialDeliveryEntity.class);
        if (entity == null) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u67e5\u5230\u8be5\u5355\u636e\uff01");
        }
        if (!entity.getSourceSystemId().equals(entity.getSourceSystemId())) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u6765\u6e90\u7cfb\u7edf\u4fe1\u606f\u4e0d\u5339\u914d\uff01");
        }
        String msg = this.service.billDel(entity);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialDeliveryVO> queryDetail(Long id) {
        MaterialDeliveryEntity entity = (MaterialDeliveryEntity)((Object)this.service.selectById(id));
        MaterialDeliveryVO vo = (MaterialDeliveryVO)BeanMapper.map((Object)((Object)entity), MaterialDeliveryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialDeliveryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("firstPartyName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        } else if (((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialDeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"/closeDelivery"})
    @ResponseBody
    public CommonResponse<String> closeDelivery(Long id) {
        MaterialDeliveryEntity entity = (MaterialDeliveryEntity)((Object)this.service.selectById(id));
        if ("2".equals(entity.getAcceptanceState())) {
            return CommonResponse.error((String)"\u9001\u8d27\u5355\u5df2\u5168\u90e8\u9a8c\u6536\uff0c\u4e0d\u80fd\u5173\u95ed\uff01");
        }
        String msg = this.service.changeCloseState(entity);
        if (null != msg) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u9001\u8d27\u5355\u5173\u95ed\u6210\u529f\uff01");
    }
}

