package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.material.bean.OwnEntity;
import com.ejianc.business.assist.material.service.IOwnService;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.material.vo.OwnDetailVO;
import com.ejianc.business.assist.material.vo.OwnVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("own")
public class OwnBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IOwnService ownService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
//    @Autowired
//    private IValidateService validateContract;
    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OwnVO ownVO = ownService.queryDetail(billId);
        LambdaUpdateWrapper<OwnEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(OwnEntity::getEffectTime, new Date());
        lambd.eq(OwnEntity::getId, billId);
        ownService.update(lambd);
        // 更新摊销金额审批通过
        StoreManageVO vo = new StoreManageVO();
        vo.setStoreId(ownVO.getProjectId());
        vo.setOutEffectiveON(true);
        vo.setInOutTypeEnum(InOutTypeEnum.周转材收料入库);

        List<FlowVO> flowVOList = new ArrayList<>();

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date lastShareDate = null;
        try {
            lastShareDate = sdf.parse(ownVO.getAmortizationCycle());
        } catch (ParseException e) {
            e.printStackTrace();
        }

        if (CollectionUtils.isNotEmpty(ownVO.getOwnDetailList())) {
            for (OwnDetailVO detailVO : ownVO.getOwnDetailList()) {
                FlowVO flowVO = new FlowVO();
                flowVO.setSourceId(detailVO.getFlowSourceId());
                flowVO.setSourceDetailId(detailVO.getFlowSourceDetailId());
                flowVO.setShareMny(detailVO.getAmortizationMny());
                flowVO.setShareTaxMny(detailVO.getAmortizationMnyTax());
                flowVO.setLastShareDate(lastShareDate);
                flowVOList.add(flowVO);
            }
        }
        vo.setFlowVOList(flowVOList);
        CommonResponse<StoreManageVO> commonResponse = storeManageApi.updateShareMny(vo);
        logger.info("更新摊销金额审批通过返回值：" + JSON.toJSONString(commonResponse));
        if (commonResponse.isSuccess()) {
            return CommonResponse.success();
        } else {
            return CommonResponse.error(commonResponse.getMsg());
        }

    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        /*OwnVO ownVO = ownService.queryDetail(billId);

        // 同一个合同只能存在一个自由态或审批中的单据
        validateContract.validateProject(ownVO.getProjectId(), null, null, MaterialConstant.弃审);
        // 校验必须大于最大单据日期
        ownService.validateTime(ownVO, MaterialConstant.弃审);
        // 是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(!res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.error(res.getMsg());
        }

        LambdaUpdateWrapper<OwnEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(OwnEntity::getEffectTime, null);
        lambd.eq(OwnEntity::getId, billId);
        ownService.update(lambd);

        // 更新摊销金额审批通过
        StoreManageVO vo = new StoreManageVO();
        vo.setStoreId(ownVO.getProjectId());
        vo.setOutEffectiveON(false);
        vo.setInOutTypeEnum(InOutTypeEnum.周转材收料入库);

        List<FlowVO> flowVOList = new ArrayList<>();

        String lastAmortizationCycle = ownService.getLastAmortizationCycle(ownVO.getProjectId(), ownVO.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date lastShareDate = null;
        if (lastAmortizationCycle != null && lastAmortizationCycle.length() > 0) {
            try {
                lastShareDate = sdf.parse(lastAmortizationCycle);
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isNotEmpty(ownVO.getOwnDetailList())) {
            for (OwnDetailVO detailVO : ownVO.getOwnDetailList()) {
                FlowVO flowVO = new FlowVO();
                flowVO.setSourceId(detailVO.getFlowSourceId());
                flowVO.setSourceDetailId(detailVO.getFlowSourceDetailId());
                flowVO.setShareMny(detailVO.getAmortizationMny());
                flowVO.setShareTaxMny(detailVO.getAmortizationMnyTax());
                flowVO.setLastShareDate(lastShareDate);
                flowVOList.add(flowVO);
            }
        }
        vo.setFlowVOList(flowVOList);

        CommonResponse<StoreManageVO> commonResponse = storeManageApi.updateShareMny(vo);
        if (commonResponse.isSuccess()) {
            return CommonResponse.success();
        } else {
            return CommonResponse.error(commonResponse.getMsg());
        }*/
        //return CommonResponse.error("单据暂不支持回退!");
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
