package com.ejianc.business.assist.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 其他入库
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assiststore_other_in")
public class OtherInEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="store_id")
    private Long storeId; // 仓库
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="check_date")
    private Date checkDate; // 验收日期
    @TableField(value="material_types")
    private String materialTypes; // 物料分类
    @TableField(value="instore_tax_mny")
    private BigDecimal instoreTaxMny; // 入库金额(无税)
    @TableField(value="instore_mny")
    private BigDecimal instoreMny; // 入库金额(含税)
    @TableField(value="employee_id")
    private Long employeeId; // 业务经办人ID
    @TableField(value="employee_name")
    private String employeeName; // 业务经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="record_flag")
    private Integer recordFlag; // 是否补录：0-否，1-是
    @TableField(value="weigh_flag")
    private Integer weighFlag; // 是否地磅称重：0-否，1-是
    @TableField(value="requir_flag")
    private Integer requirFlag; // 是否符合要求：0-否，1-是
    @TableField(value = "source_type")
    private Integer sourceType; // 单据来源：0-自制

    @TableField(exist=false)
    @SubEntity(serviceName="otherInService",pidName = "inId")
    private List<OtherInDetailEntity> otherInDetailList = new ArrayList<>(); // 材料明细实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public String getMaterialTypes() {
        return materialTypes;
    }

    public void setMaterialTypes(String materialTypes) {
        this.materialTypes = materialTypes;
    }
    public BigDecimal getInstoreTaxMny() {
        return instoreTaxMny;
    }

    public void setInstoreTaxMny(BigDecimal instoreTaxMny) {
        this.instoreTaxMny = instoreTaxMny;
    }
    public BigDecimal getInstoreMny() {
        return instoreMny;
    }

    public void setInstoreMny(BigDecimal instoreMny) {
        this.instoreMny = instoreMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getRecordFlag() {
        return recordFlag;
    }

    public void setRecordFlag(Integer recordFlag) {
        this.recordFlag = recordFlag;
    }
    public Integer getWeighFlag() {
        return weighFlag;
    }

    public void setWeighFlag(Integer weighFlag) {
        this.weighFlag = weighFlag;
    }
    public Integer getRequirFlag() {
        return requirFlag;
    }

    public void setRequirFlag(Integer requirFlag) {
        this.requirFlag = requirFlag;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public List<OtherInDetailEntity> getOtherInDetailList() {
        return otherInDetailList;
    }

    public void setOtherInDetailList(List<OtherInDetailEntity> otherInDetailList) {
        this.otherInDetailList = otherInDetailList;
    }
}
