package com.ejianc.business.assist.rmat.service.impl;

import com.ejianc.business.assist.rmat.bean.RentCalculateEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.mapper.RentCalculateMapper;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.service.IRentCalculateService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.rmat.vo.RentCalculateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 租金计算单
 * 
 * @author generator
 * 
 */
@Service("rentCalculateService")
public class RentCalculateServiceImpl extends BaseServiceImpl<RentCalculateMapper, RentCalculateEntity> implements IRentCalculateService{

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IMaterialService materialService;

    private static final String BILL_CODE = "ASSIST_RMAT_RENT_CALCULATE";//此处需要根据实际修改
    private static final String BILL_NAME = BillTypeEnum.租金计算单.getName();

    @Override
    public RentCalculateVO saveOrUpdate(RentCalculateVO saveOrUpdateVO) {
        // 同一个合同只能存在一个自由态或审批中的单据
        materialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), MaterialConstant.保存);
        // 校验必须大于最大单据日期
        this.validateTime(saveOrUpdateVO, MaterialConstant.保存);
        RentCalculateEntity entity = BeanMapper.map(saveOrUpdateVO, RentCalculateEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, RentCalculateVO.class);
    }

    @Override
    public String validateTime(RentCalculateVO rentVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", rentVO.getContractId());
        if(rentVO.getId() != null){
            params.put("billType", BILL_NAME);
            params.put("billId", rentVO.getId());
        }
        Date lastDate = materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = materialService.getMaxTime(params);

        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(rentVO.getRentDate(), lastDate, maxTimeMap, rentVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(rentVO.getRentDate())
                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        return "校验通过！";
    }
}
