package com.ejianc.business.outrmat.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.enums.*;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractAsyncService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractChangeService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Service("outRmatContractChange")
public class OutRmatContractChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";


	@Autowired
	private IOutRmatContractChangeService service;

	@Autowired
	private IOutRmatContractService contractService;

	@Autowired
	private IParamConfigApi paramConfigApi;

	@Autowired
	private ISignatureCommonApi signatureCommonApi;

	@Autowired
	private IOutRmatContractAsyncService contractAsyncService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRmatContractChangeEntity changeEntity = service.selectById(billId);

		if (DraftTypeEnum.线下签订.getCode().equals(changeEntity.getChangeDraftType())){
			// 调用生效回写服务
			service.effectiveSaveWriteContract(billId, billTypeCode, false);
		}else {
			LambdaUpdateWrapper<OutRmatContractChangeEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(OutRmatContractChangeEntity::getCommitDate, new Date());
			wrapper.eq(OutRmatContractChangeEntity::getId, billId);
			service.update(wrapper);

			// 回写主合同信息
//			LambdaUpdateWrapper<OutRmatContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
//			updateWrapper.set(OutRmatContractEntity::getChangeStatus, ChangeStatusEnum.变更单据审批通过.getCode());
//			updateWrapper.eq(OutRmatContractEntity::getId, changeEntity.getContractId());
//			contractService.update(updateWrapper);
			OutRmatContractEntity outRmatContractEntity = contractService.selectById(changeEntity.getMainContractId());
			outRmatContractEntity.setChangeStatus(ChangeStatusEnum.变更单据审批通过.getCode());
			contractService.saveOrUpdate(outRmatContractEntity);
			// 推送变更状态到周转材
			contractService.pushContractToRmat(BeanMapper.map(outRmatContractEntity, OutRmatContractVO.class),
					OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD, OutRmatConstant.PUSH_RMAT_OPT_BILL_CONTRACT_CHANGE);
		}

		// 水印系统参数
		CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
		if (!response.isSuccess() || response.getData() == null) {
			throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
		}
		String valueData = response.getData().getValueData();
		Assert.hasText(valueData, "获取的水印系统参数不能为空!");

		// 是否限制： 0:不限制，1:限制
		if ("0".equals(valueData)) {
			// 转换水印参数配置：默认规则
			WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(),
					changeEntity.getBillCode(), BillTypeEnum.辅料中心租出合同变更.getCode(), "arContractChange");
			Assert.notNull(watermarkVO, "获取水印系统参数失败!");
			// 获取上下文并异步调用添加水印
			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			HashMap<String, String> headers = new HashMap<>();
			headers.put("authority", request.getHeader("authority"));
			headers.put("ejc-token", request.getHeader("ejc-token"));
			contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBpmBack(billId, state, billTypeCode);
	}

	/**
	 * @param billId
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = null;
		//提交通过、且未签章则可弃审
		OutRmatContractChangeEntity changeEntity = service.selectById(billId);

		// 审批可以撤回的签章状态集合
		List<Integer> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());

		// 变更单生效后不允许撤回
		if(!statusList.contains(changeEntity.getSignatureStatus())) {
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}

		if(PerformanceStatusEnum.履约中.getCode().equals(changeEntity.getPerformanceStatus())) {
			changeEntity.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());
		}

		// 删除文件中心水印文件
		if(changeEntity.getWatermarkContractChangeFileId() != null) {
			boolean delWatermarkflag = contractService.delWatermarkContractFile(changeEntity.getWatermarkContractChangeFileId());
			if (delWatermarkflag) {
				changeEntity.setWatermarkContractChangeFileId(null);
			}
		}

		changeEntity.setCommitDate(null);
//		changeEntity.setCommitUserCode(null);
//		changeEntity.setCommitUserName(null);
		changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
		service.saveOrUpdate(changeEntity);
		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));

		OutRmatContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		contractService.saveOrUpdate(contractEntity, false);
		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

		// 推送变更状态到周转材
		contractService.pushContractToRmat(BeanMapper.map(contractEntity, OutRmatContractVO.class),
				OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD, OutRmatConstant.PUSH_RMAT_OPT_BILL_CONTRACT_CHANGE);

		return CommonResponse.success("执行变更单撤回回调逻辑成功！");
	}

}
