/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.delivery.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryDetailEntity;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.delivery.enums.SignStatusEnum;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryDetailService;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryVO;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDeliveryService;
import com.ejianc.business.outrmat.proxy.bean.ProxyContractEntity;
import com.ejianc.business.outrmat.proxy.service.IProxyContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outRmatDelivery"})
public class OutRmatDeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "out-rmat-delivery";
    @Autowired
    private IOutRmatDeliveryService service;
    @Autowired
    private IOutRmatOrderDeliveryService outRmatOrderDeliveryService;
    @Autowired
    private IOutRmatDeliveryDetailService outRmatDeliveryDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProxyContractService proxyContractService;
    @Autowired
    private IRmatFlowService flowService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRmatDeliveryVO> saveOrUpdate(@RequestBody OutRmatDeliveryVO saveOrUpdateVO) {
        this.service.validateTime(saveOrUpdateVO);
        OutRmatDeliveryEntity entity = (OutRmatDeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatDeliveryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getOutRmatDeliveryDetailList())) {
            List<OutRmatDeliveryDetailEntity> outRmatDeliveryDetailList = entity.getOutRmatDeliveryDetailList();
            List<OutRmatDeliveryDetailEntity> delDetail = outRmatDeliveryDetailList.stream().filter(t -> "del".equals(t.getRowState())).collect(Collectors.toList());
            this.outRmatOrderDeliveryService.delete(delDetail, null);
            boolean b = outRmatDeliveryDetailList.stream().anyMatch(e -> e.getTransScale() == null);
            if (b) {
                throw new BusinessException("\u90e8\u5206\u6750\u6599\u672a\u8bbe\u7f6e\u8f6c\u6362\u7cfb\u6570,\u4e0d\u80fd\u4fdd\u5b58");
            }
        }
        entity.setSignStatus(SignStatusEnum.\u672a\u7b7e\u5b57.getCode());
        ProxyContractEntity proxyContractEntity = (ProxyContractEntity)((Object)this.proxyContractService.selectById(entity.getProxyContractId()));
        entity.setProxyEmployeeId(proxyContractEntity.getProxyEmployeeId());
        entity.setProxyEmployeeName(proxyContractEntity.getProxyEmployeeName());
        this.service.saveOrUpdate((Object)entity, false);
        this.outRmatOrderDeliveryService.saveOrUpdate(entity.getOutRmatDeliveryDetailList(), entity.getContractId());
        OutRmatDeliveryVO vo = (OutRmatDeliveryVO)BeanMapper.map((Object)((Object)entity), OutRmatDeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRmatDeliveryVO> queryDetail(Long id) {
        OutRmatDeliveryEntity entity = (OutRmatDeliveryEntity)((Object)this.service.selectById(id));
        OutRmatDeliveryVO vo = (OutRmatDeliveryVO)BeanMapper.map((Object)((Object)entity), OutRmatDeliveryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatDeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OutRmatDeliveryVO outRmatDeliveryVO : vos) {
            }
        }
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
        listWrapper.in(OutRmatDeliveryDetailEntity::getDeliveryId, ids);
        List outRmatDeliveryDetailEntities = this.outRmatDeliveryDetailService.list((Wrapper)listWrapper);
        this.outRmatOrderDeliveryService.delete(outRmatDeliveryDetailEntities, null);
        if (!this.flowService.delFlow(ids, BillTypeEnum.\u79df\u51fa\u51fa\u5e93\u5355.getCode()).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u5220\u9664\u6d41\u6c34\u5931\u8d25\uff01");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutRmatDeliveryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("rentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRmatDeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("rentName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List outRmatDeliveryVOS = BeanMapper.mapList((Iterable)list, OutRmatDeliveryVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            outRmatDeliveryVOS = BeanMapper.mapList((Iterable)list, OutRmatDeliveryVO.class);
            outRmatDeliveryVOS.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setRentTypeName(vo.getRentType() == 0 ? "\u5916\u79df" : "\u5185\u79df");
            });
        }
        beans.put("records", outRmatDeliveryVOS);
        ExcelExport.getInstance().export("OutRmatDelivery-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOutRmatDeliveryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRmatDeliveryVO>> refOutRmatDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRmatDeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

