/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.PickReturnEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IPickReturnService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.PickReturnDetailVO;
import com.ejianc.business.assist.store.vo.PickReturnVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pickReturn")
public class PickReturnBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPickReturnService pickReturnService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private IStoreCheckService checkService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnService.selectById(billId));
        PickReturnVO pickReturnVO = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
        if (pickReturnVO != null && pickReturnVO.getPickReturnDetailList().size() > 0) {
            Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
            detailMap.forEach((storeId, value) -> {
                List detailVOS = (List)detailMap.get(storeId);
                pickReturnVO.setPickReturnDetailList(detailVOS);
                StoreManageVO storeManageVO = pickReturnVO.getStoreManageVO(pickReturnVO, storeId);
                this.storeManageService.inOutStore(storeManageVO);
            });
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnService.selectById(billId));
        if (entity != null) {
            CommonResponse commonResponse = this.checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getInstoreDate()));
            return commonResponse;
        }
        return CommonResponse.error((String)"\u5355\u636e\u5f02\u5e38\uff0c\u5f03\u5ba1\u5931\u8d25");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnService.selectById(billId));
        if (entity != null && entity.getPickReturnDetailList().size() > 0) {
            PickReturnVO pickReturnVO = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
            Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
            detailMap.forEach((storeId, value) -> {
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setSourceId(entity.getId());
                storeManageVO.setStoreId(storeId);
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u9000\u5e93);
                this.storeManageService.inOutStoreRollback(storeManageVO);
            });
        }
        return CommonResponse.success();
    }
}

