package com.ejianc.business.outrmat.calculate.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 租金计算单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_outrmat_rent_calculate")
public class OutRmatCalculateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 项目组织id
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="org_name")
    private String orgName; // 项目组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="rent_calculation_type")
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    @TableField(value="month_settlement_day")
    private Integer monthSettlementDay; // 月结算日
    @TableField(value="rent_date")
    private Date rentDate; // 租金计算日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="rent_tax_mny")
    private BigDecimal rentTaxMny; // 本次租赁金额
    @TableField(value="rent_mny")
    private BigDecimal rentMny; // 本次租赁金额(无税)
    @TableField(value="rent_tax")
    private BigDecimal rentTax; // 本次租赁税额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="settle_flag")
    private Integer settleFlag; // 是否结算 0-未结算，1-已结算
    @TableField(value="calculate_type")
    private String calculateType; // 租金计算类型（0：手动计算，1：自动计算）
    @TableField(value="out_org_id")
    private Long outOrgId; // 租出单位id
    @TableField(value="out_org_code")
    private String outOrgCode; // 租出单位code
    @TableField(value="out_org_name")
    private String outOrgName; // 租出单位name
    @TableField(value="rent_type")
    private String rentType; // 租赁方式(0-外租，1-内租)


    @TableField(exist=false)
    @SubEntity(serviceName="outRmatCalculateDailyService", pidName = "rentId")
    private List<OutRmatCalculateDailyEntity> dailyList = new ArrayList<>(); // 租金计算单-日租
    @TableField(exist=false)
    @SubEntity(serviceName="outRmatCalculateMonthService", pidName = "rentId")
    private List<OutRmatCalculateMonthEntity> monthList = new ArrayList<>(); // 租金计算单-月租
    @TableField(exist=false)
    @SubEntity(serviceName="outRmatCalculateNumService", pidName = "rentId")
    private List<OutRmatCalculateNumEntity> numList = new ArrayList<>(); // 租金计算单-工程量租
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }
    public Integer getMonthSettlementDay() {
        return monthSettlementDay;
    }

    public void setMonthSettlementDay(Integer monthSettlementDay) {
        this.monthSettlementDay = monthSettlementDay;
    }
    public Date getRentDate() {
        return rentDate;
    }

    public void setRentDate(Date rentDate) {
        this.rentDate = rentDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }
    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }
    public BigDecimal getRentTax() {
        return rentTax;
    }

    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }
    public String getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(String calculateType) {
        this.calculateType = calculateType;
    }

    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }

    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }

    public List<OutRmatCalculateDailyEntity> getDailyList() {
        return dailyList;
    }

    public void setDailyList(List<OutRmatCalculateDailyEntity> dailyList) {
        this.dailyList = dailyList;
    }

    public List<OutRmatCalculateMonthEntity> getMonthList() {
        return monthList;
    }

    public void setMonthList(List<OutRmatCalculateMonthEntity> monthList) {
        this.monthList = monthList;
    }

    public List<OutRmatCalculateNumEntity> getNumList() {
        return numList;
    }

    public void setNumList(List<OutRmatCalculateNumEntity> numList) {
        this.numList = numList;
    }
}
