package com.ejianc.business.outrmat.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.outrmat.contract.enums.StatusTypeEnum;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryVO;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.outrmat.delivery.mapper.OutRmatDeliveryMapper;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * out-出库单
 * 
 * @author generator
 * 
 */
@Service("outRmatDeliveryService")
public class OutRmatDeliveryServiceImpl extends BaseServiceImpl<OutRmatDeliveryMapper, OutRmatDeliveryEntity> implements IOutRmatDeliveryService{
    @Autowired
    private OutRmatDeliveryMapper baseMapper;
    @Autowired
    private PushSupUtil pushSupUtil;
    private static final String BILL_TYPE = StatusTypeEnum.租出出库单.getCode();
    private static final String BILL_NAME = StatusTypeEnum.租出出库单.getName();
    
    @Override
    public void validateTime(OutRmatDeliveryVO saveOrUpdateVO) {
            OutRmatDeliveryEntity outRmatDeliveryEntity = super.selectById(saveOrUpdateVO.getId());
            Date lastDate = baseMapper.getContractLastDate(saveOrUpdateVO.getContractId(),saveOrUpdateVO.getId());
            if (lastDate != null && lastDate.compareTo(saveOrUpdateVO.getRentDate()) > 0){
                throw new BusinessException("计租日期小于当前单据同合同下最大计租日期【" + DateUtil.formatDate(saveOrUpdateVO.getRentDate()) + "】，不允许保存!");
            }
        //大于等于  租出、启用、停用....等关键单据的日期；
        Date lastAllBillDate = baseMapper.getLastDate(saveOrUpdateVO.getContractId());
        if (lastAllBillDate != null && lastAllBillDate.compareTo(saveOrUpdateVO.getRentDate()) > 0){
            throw new BusinessException("计租日期小于下游单据最大计租日期【" + DateUtil.formatDate(saveOrUpdateVO.getRentDate()) + "】，不允许保存!");
        }
//        子表计租日期：必填，默认主表计租日期，可修改，格式：yyyy-mm-dd。大于最新一期租金计算日期（含未结算的租金计算单）。

    }

    @Override
    public String updateBillSupSignSync(Map<String,String> map) {
        String billId = map.get("billId");
        OutRmatDeliveryEntity entity = super.selectById(Long.valueOf(billId));
        String msg = pushSupUtil.updateBillSupSignSync(map, (JSONObject) JSONObject.toJSON(entity),
                OutRmatDeliveryEntity.class, BILL_TYPE, BILL_NAME);
        return msg;
    }
}
