package com.ejianc.business.assist.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.service.IContractFileService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping()
public class ContractFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private IContractFileService service;


    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "/contractFileUpdate/updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();

        ContractEntity contract = contractService.selectById(updateData.getLong("billId"));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));

        contractService.saveOrUpdate(contract, false);

        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", contract);
        return CommonResponse.success("合同文件信息更新成功！",resp);
    }
    @GetMapping(value = "/contractFileUpdate/getBillDataJson")
    public CommonResponse<ContractVO> getBillDataJson(@RequestParam Long id) {
        logger.info("-----查询合同子表合并-----合同id：{}", id);
        ContractEntity contract = contractService.selectById(id);
        ContractVO vo = BeanMapper.map(contract, ContractVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,##0.00");
        if(CollectionUtils.isNotEmpty(vo.getDailyRentList())) {
            vo.getDailyRentList().forEach(item -> {
                item.setCountStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitPriceStr(null != item.getLoseUnitPrice() ? priceFmt.format(item.getLoseUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitTaxPriceStr(null != item.getLoseUnitTaxPrice() ? priceFmt.format(item.getLoseUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopUnitPriceStr(null != item.getStopUnitPrice() ? priceFmt.format(item.getStopUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopUnitTaxPriceStr(null != item.getStopUnitTaxPrice() ? priceFmt.format(item.getStopUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setSurplusCountStr(null != item.getSurplusCount() ? priceFmt.format(item.getSurplusCount()) : priceFmt.format(BigDecimal.ZERO));

                item.setTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxStr(null != item.getRentTax() ? mnyFmt.format(item.getRentTax()) : mnyFmt.format(BigDecimal.ZERO));

                item.setStartDateStr(null != item.getStartDate() ? DateFormatUtil.formatDate("yyyy-MM-dd", item.getStartDate()) : "");
                item.setEndDateStr(null != item.getEndDate() ? DateFormatUtil.formatDate("yyyy-MM-dd", item.getEndDate()) : "");
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getMonthRentList())) {
            vo.getMonthRentList().forEach(item -> {
                item.setCountStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitPriceStr(null != item.getLoseUnitPrice() ? priceFmt.format(item.getLoseUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitTaxPriceStr(null != item.getLoseUnitTaxPrice() ? priceFmt.format(item.getLoseUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopUnitPriceStr(null != item.getStopUnitPrice() ? priceFmt.format(item.getStopUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopUnitTaxPriceStr(null != item.getStopUnitTaxPrice() ? priceFmt.format(item.getStopUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setSurplusCountStr(null != item.getSurplusCount() ? priceFmt.format(item.getSurplusCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setLackMonthDayUnitPriceStr(null != item.getLackMonthDayUnitPrice() ? priceFmt.format(item.getLackMonthDayUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLackMonthDayUnitTaxPriceStr(null != item.getLackMonthDayUnitTaxPrice() ? priceFmt.format(item.getLackMonthDayUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));

                item.setTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxStr(null != item.getRentTax() ? mnyFmt.format(item.getRentTax()) : mnyFmt.format(BigDecimal.ZERO));

                item.setStartDateStr(null != item.getStartDate() ? DateFormatUtil.formatDate("yyyy-MM-dd", item.getStartDate()) : "");
                item.setEndDateStr(null != item.getEndDate() ? DateFormatUtil.formatDate("yyyy-MM-dd", item.getEndDate()) : "");
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getNumRentList())) {
            vo.getNumRentList().forEach(item -> {
                item.setCountStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitPriceStr(null != item.getLoseUnitPrice() ? priceFmt.format(item.getLoseUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitTaxPriceStr(null != item.getLoseUnitTaxPrice() ? priceFmt.format(item.getLoseUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setSurplusCountStr(null != item.getSurplusCount() ? priceFmt.format(item.getSurplusCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setQuantitiesStr(null != item.getQuantities() ? priceFmt.format(item.getQuantities()) : priceFmt.format(BigDecimal.ZERO));

                item.setTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxStr(null != item.getRentTax() ? mnyFmt.format(item.getRentTax()) : mnyFmt.format(BigDecimal.ZERO));

                item.setStartDateStr(null != item.getStartDate() ? DateFormatUtil.formatDate("yyyy-MM-dd", item.getStartDate()) : "");
                item.setEndDateStr(null != item.getEndDate() ? DateFormatUtil.formatDate("yyyy-MM-dd", item.getEndDate()) : "");
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getOtherList())) {
            vo.getOtherList().forEach(item -> {
                item.setOtherPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherMnyStr(null != item.getMny() ? mnyFmt.format(item.getMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherTaxMnyStr(null != item.getTaxMny() ? mnyFmt.format(item.getTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherNumStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getRepairList())) {
            vo.getRepairList().forEach(item -> {
                item.setRepairPriceStr(null != item.getRepairPrice() ? priceFmt.format(item.getRepairPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setRepairTaxPriceStr(null != item.getRepairTaxPrice() ? priceFmt.format(item.getRepairTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setRepairTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRepairTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getScrapList())) {
            vo.getScrapList().forEach(item -> {
                item.setScrapPriceStr(null != item.getDamageScrapPrice() ? priceFmt.format(item.getDamageScrapPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setScrapTaxPriceStr(null != item.getDamageScrapTaxPrice() ? priceFmt.format(item.getDamageScrapTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setScrapTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setScrapTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getPaymentList())) {
            vo.getPaymentList().forEach(item -> {
                item.setPaymentScaleStr(null != item.getPaymentScale() ? mnyFmt.format(item.getPaymentScale()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getClauseList())) {
            vo.getClauseList().forEach(item -> {
                /**
                 * 是否必填 0否  1是
                 */
                item.setNecessaryStatusStr(null != item.getNecessaryStatus() && item.getNecessaryStatus()==1  ?  "是":"否" );
            });
        }
        return CommonResponse.success(vo);
    }

    /**
     * 获取合同签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType 单据类型：contract-主合同/变更协议, contractChange-合同变更、协议变更
     * @return
     */
    @GetMapping(value = "/billFileUpdate/getSignedFileInfo")
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {

        return CommonResponse.success("查询成功！", service.getSignedFileInfo(billId, billType));
    }
}
