package com.ejianc.business.assist.rmat.service;

import com.ejianc.business.assist.rmat.bean.SettleEntity;
import com.ejianc.business.assist.rmat.vo.*;
import com.ejianc.business.assist.rmat.vo.record.SettleRecordVO;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteOtherVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 周转材租赁结算单
 * 
 * @author generator
 * 
 */
public interface ISettleService extends IBaseService<SettleEntity> {

    SettleVO saveOrUpdate(SettleVO saveOrUpdateVO);
    
    String validateContract(Long contractId, Long billId);
    
    List<RentCalculateVO> queryCalculateData(Long contractId, String lastSettleDate, String settleDate);
    
    List<RestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate);

    List<RestituteOtherVO> queryRestituteOtherData(Long contractId, String lastSettleDate, String settleDate);

    List<LoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate);

    SettleVO queryLastSettleTaxMny(Long contractId, Long billId);

    SettleRecordVO querySettleRecord(Long id);

    Boolean pushSettleToPool(SettleVO vo);

    Boolean delSettleFromPool(Long id);

    ExecutionVO targetCost(SettleEntity entity);

    Boolean pushContract(SettleVO vo, String updateLevel);

    Boolean pushBillToSupCenter(SettleEntity entity);

    Boolean delPushBill(SettleEntity entity);

    String updateBillSupSignSyncInfo(HttpServletRequest request);
    
}
