package com.ejianc.business.outrmat.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRelieveEntity;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.enums.SignatureStatusEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRelieveService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("outRmatContractRelieve") 
public class OutRmatContractRelieveBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IOutRmatContractRelieveService service;

	@Autowired
	private IOutRmatContractService contractService;

	@Autowired
	private IExecutionApi executionApi;

	@Autowired
	private IContractPoolApi contractPoolApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		OutRmatContractRelieveEntity entity = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		entity.setCommitDate(new Date());
		entity.setCommitUserCode(userContext.getUserCode());
		entity.setCommitUserName(userContext.getUserName());

		// 已签章
		if (entity.getDraftType() == 2) {
			entity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());

			entity.setEffectiveDate(new Date());
			service.saveOrUpdate(entity, false);

			QueryParam param = new QueryParam();
			param.getParams().put("id", new Parameter(QueryParam.EQ, entity.getContractId()));
			List<OutRmatContractEntity> contractEntities = contractService.queryList(param, false);
			if (ListUtil.isNotEmpty(contractEntities)) {
				OutRmatContractEntity outRmatContractEntity = contractEntities.get(0);
				outRmatContractEntity.setPerformanceStatus(PerformanceStatusEnum.已作废.getCode());
				logger.info("======终审审核完回调,已签章======,{}", JSONObject.toJSONString(outRmatContractEntity));
				contractService.saveOrUpdate(outRmatContractEntity, false);

				// 推送合同到周转材项目(修改合同状态)
				contractService.pushContractToRmat(JSONObject.parseObject(JSONObject.toJSONString(entity)),
						OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD, OutRmatConstant.PUSH_RMAT_OPT_BILL_CONTRACT_RELIEVE,outRmatContractEntity.getRentType());

				// 合同推送合同池，更新解除状态
//				boolean pushResult = contractService.pushContract(BeanMapper.map(outRmatContractEntity, OutRmatContractVO.class));
//				if(pushResult) {
//					outRmatContractEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
//				} else {
//					outRmatContractEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
//				}


				// 推送目标成本
//					CommonResponse<String> response = executionApi.aggPush(service.targetCost(entity));
//					logger.info("推送目标成本入参：" + JSONObject.toJSONString(service.targetCost(entity)));
//					if (!response.isSuccess()){
//						logger.error("推送目标成本失败: , {}", response.getMsg());
//						throw new BusinessException(response.getMsg());
//					}

//				contractService.saveOrUpdate(outRmatContractEntity, false);
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		OutRmatContractRelieveEntity entity = service.selectById(billId);

		// 审批可以撤回的签章状态集合
		List<Integer> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());

		// 使用电子签章且已有签章流程则不允许撤回
		if(Integer.valueOf(1).equals(entity.getDraftType()) && !statusList.contains(entity.getSignatureStatus())) {
			return CommonResponse.error("合同解除" + (SignatureStatusEnum.已签章.getCode().equals(entity.getSignatureStatus()) ? "已生效" : "已有签章流程")  + "，不允许弃审!");
		}else if(SignatureStatusEnum.已签章.getCode().equals(entity.getSignatureStatus())) {
			entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
			service.saveOrUpdate(entity, false);
		}

		// 更新合同履约状态
		ContractPoolVO contractPoolVO = new ContractPoolVO();
		contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
		contractPoolVO.setSourceId(entity.getContractId());
		contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);

		// 解除单撤回后，更新合同状态为履约中
//		LambdaUpdateWrapper<OutRmatContractEntity> wrapper = new LambdaUpdateWrapper<>();
//		wrapper.eq(OutRmatContractEntity::getId, entity.getContractId());
//		wrapper.set(OutRmatContractEntity::getPerformanceStatus, PerformanceStatusEnum.履约中.getCode());
//		contractService.update(wrapper);
		OutRmatContractEntity outRmatContractEntity = contractService.selectById(entity.getContractId());
		outRmatContractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
		contractService.saveOrUpdate(outRmatContractEntity);

		// 推送合同到周转材项目(修改合同状态)
		contractService.pushContractToRmat(JSONObject.parseObject(JSONObject.toJSONString(entity)),
				OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD, OutRmatConstant.PUSH_RMAT_OPT_BILL_CONTRACT_RELIEVE,outRmatContractEntity.getRentType());


		return CommonResponse.success();
	}

}
