package com.ejianc.business.outrmat.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.vo.RentCalculateVO;
import com.ejianc.business.outrmat.calculate.vo.OutRmatCalculateVO;
import com.ejianc.business.outrmat.contract.enums.BillPushStatusEnum;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.enums.SupplierSignStatusEnum;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractSettleRecordVO;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteOtherVO;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteVO;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleEntity;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.outrmat.settle.vo.OutRmatSettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 周转材租赁结算单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRmatSettle")
public class OutRmatSettleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    
    @Autowired
    private IOrgApi iOrgApi;
    
    @Autowired
    private IOutRmatSettleService service;

    @Autowired
    private IShareCooperateApi shareCooperateApi;

    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/assistrmat/outRmatSettle/card";
    

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRmatSettleVO> saveOrUpdate(@RequestBody OutRmatSettleVO saveOrUpdateVO) {
        
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRmatSettleVO> queryDetail(Long id) {
    	OutRmatSettleEntity entity = service.selectById(id);
    	OutRmatSettleVO vo = BeanMapper.map(entity, OutRmatSettleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatSettleVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutRmatSettleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutRmatSettleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutRmatSettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        if(!param.getParams().containsKey("orgId")){// 非移动端默认项目，走PC端
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        } else if (param.getParams().get("orgId").getValue() != null){ // 移动端默认项目、默认组织
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Parameter settleDate = param.getParams().get("settleDate");
        if (!Objects.equals(settleDate, null)) {
            String value = settleDate.getValue().toString();
            String[] split = value.split(",");
            String startSetlleDate = split[0] + " 00:00:00";
            String endSetlleDate = split[1] + " 23:59:59";
            param.getParams().remove("settleDate");
            param.getParams().put("settleDate", new Parameter(QueryParam.BETWEEN, startSetlleDate + "," + endSetlleDate));
        }
        
        IPage<OutRmatSettleEntity> page = service.queryPage(param,false);
        IPage<OutRmatSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRmatSettleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        
        
        List<OutRmatSettleEntity> list = service.queryList(param);
        //todo:字段翻译等等

        List<OutRmatSettleVO> voList = BeanMapper.mapList(list, OutRmatSettleVO.class);
        for (OutRmatSettleVO vo : voList) {
            if (vo.getSupplierSignStatus().equals(0)) {
                vo.setSupplierSignStatusName("未签字");
            }else if (vo.getSupplierSignStatus().equals(1)) {
                vo.setSupplierSignStatusName("已签字");
            }else {
                vo.setSupplierSignStatusName("未签字");
            }

            // 单据状态名称
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("outRmatSettle-export.xlsx", beans, response);
    }
    
    /**
     * 校验当前合同下是否存在未生效结算单
     * @param contractId
     * @param billId
     * @return
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateContract(contractId, billId);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * 查询租金计算单
     * @param contractId
     * @param settleDate
     * @return
     */
    @RequestMapping(value = "/queryCalculateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutRmatCalculateVO>> queryCalculateData(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "lastSettleDate", required = false) String lastSettleDate
            , @RequestParam(value = "settleDate", required = false) String settleDate) {

        return CommonResponse.success("查询租金计算单成功！", service.queryCalculateData(contractId, lastSettleDate, settleDate));
    }
    
    /**
     * 查询退赔单
     * @param contractId
     * @param settleDate
     * @return
     */
    @RequestMapping(value = "/queryRestituteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutRmatRestituteVO>> queryRestituteData(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "lastSettleDate", required = false) String lastSettleDate
            , @RequestParam(value = "settleDate", required = false) String settleDate) {
        
        return CommonResponse.success("查询退赔单成功！", service.queryRestituteData(contractId, lastSettleDate, settleDate));
    }

    /**
     * 查询退赔单其他费用
     * @param contractId
     * @param settleDate
     * @return
     */
    @RequestMapping(value = "/queryRestituteOtherData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutRmatRestituteOtherVO>> queryRestituteOtherData(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "lastSettleDate", required = false) String lastSettleDate
            , @RequestParam(value = "settleDate", required = false) String settleDate) {

        return CommonResponse.success("查询退赔单成功！", service.queryRestituteOtherData(contractId, lastSettleDate, settleDate));
    }


    /**
     * 查询遗失单
     * @param contractId
     * @param settleDate
     * @return
     */
    @RequestMapping(value = "/queryLoseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutRmatLoseVO>> queryLoseData(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "lastSettleDate", required = false) String lastSettleDate
            , @RequestParam(value = "settleDate", required = false) String settleDate) {

        return CommonResponse.success("查询遗失单成功！", service.queryLoseData(contractId, lastSettleDate, settleDate));
    }

    /**
     * 查询不含本期已结算金额
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/queryLastSettleTaxMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRmatSettleVO> queryLastSettleTaxMny(@RequestParam("contractId") Long contractId
            , @RequestParam(value = "billId", required = false) Long billId) {

        return CommonResponse.success("查询遗失单成功！", service.queryLastSettleTaxMny(contractId, billId));
    }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySettleRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRmatContractSettleRecordVO> querySettleRecord(@RequestParam Long id) {
        OutRmatContractSettleRecordVO vo = service.querySettleRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @GetMapping(value = "/getBillShareLink")
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        OutRmatSettleEntity entity = service.selectById(id);
        if(SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus())
                && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            // 未曾成功推送单据，则先向供方推送单据
            boolean pushResult = service.pushBillToSupCenter(entity);
            if(!pushResult) {
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                service.saveOrUpdate(entity, false);
            }
        }
        return shareCooperateApi.getShareLink(id, BillTypeEnum.辅料中心租出合同结算单.getCode(), entity.getSupplierId().toString(),
                mobileBillShareFrontUrl, null);
    }
    
}
