package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.BatchPlanDetailEntity;
import com.ejianc.business.assist.rmat.bean.BatchPlanEntity;
import com.ejianc.business.assist.rmat.bean.TotalPlanEntity;
import com.ejianc.business.assist.rmat.service.IBatchPlanDetailService;
import com.ejianc.business.assist.rmat.service.IBatchPlanService;
import com.ejianc.business.assist.rmat.service.ITotalPlanService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.stream.Collectors;

@Service("totalPlan") 
public class TotalPlanBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ITotalPlanService totalPlanService;
	@Autowired
	private IBatchPlanService batchPlanService;
	@Autowired
	private IBatchPlanDetailService batchPlanDetailService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        TotalPlanEntity totalPlanEntity = totalPlanService.selectById(billId);
        if(totalPlanEntity.getChangeStatus() == 2){
            return CommonResponse.error("总计划变更中，不允许回退!");
        }
        LambdaQueryWrapper<BatchPlanEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(BatchPlanEntity::getProjectId,totalPlanEntity.getProjectId());
        lambd.eq(BatchPlanEntity::getDr,0);
        List<BatchPlanEntity> batchPlanEntities = batchPlanService.list(lambd);
        if(CollectionUtils.isNotEmpty(batchPlanEntities)){
            List<Long> batchIds = batchPlanEntities.stream().map(BatchPlanEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<BatchPlanDetailEntity> detailLambd = new LambdaQueryWrapper<>();
            detailLambd.in(BatchPlanDetailEntity::getBatchId,batchIds);
            detailLambd.eq(BatchPlanDetailEntity::getSourceType,3);
            detailLambd.eq(BatchPlanDetailEntity::getDr,0);
            List<BatchPlanDetailEntity> batchPlanDetailEntities = batchPlanDetailService.list(detailLambd);
            if(CollectionUtils.isNotEmpty(batchPlanDetailEntities)){
                return CommonResponse.error("清单被下游单据引用，不允许回退!");
            }
        }
        return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
