package com.ejianc.business.assist.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 原材料加工
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assiststore_process")
public class ProcessEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="store_id")
    private Long storeId; // 入库仓库
    @TableField(value="store_name")
    private String storeName; // 入库仓库名称
    @TableField(value="process_date")
    private Date processDate; // 加工日期
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 成本金额(无税)
    @TableField(value="cost_tax_mny")
    private BigDecimal costTaxMny; // 成本金额
    @TableField(value="process_cost_mny")
    private BigDecimal processCostMny; // 加工成本金额
    @TableField(value="process_cost_tax_mny")
    private BigDecimal processCostTaxMny; // 加工成本金额
    @TableField(value="employee_id")
    private Long employeeId; // 业务经办人ID
    @TableField(value="employee_name")
    private String employeeName; // 业务经办人名称
    @TableField(value="process_reason")
    private String processReason; // 加工原因
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="out_store_names")
    private String outStoreNames; // 出库仓库名称

    @TableField(exist=false)
    @SubEntity(serviceName="processRawService",pidName = "processId")
    private List<ProcessRawEntity> processRawList = new ArrayList<>(); // 原材料明细实体
    @TableField(exist=false)
    @SubEntity(serviceName="processCostService",pidName = "processId")
    private List<ProcessCostEntity> processCostList = new ArrayList<>(); // 加工费明细
    @TableField(exist=false)
    @SubEntity(serviceName="processProductService",pidName = "processId")
    private List<ProcessProductEntity> processProductList = new ArrayList<>(); // 成品明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }
    public BigDecimal getProcessCostMny() {
        return processCostMny;
    }

    public void setProcessCostMny(BigDecimal processCostMny) {
        this.processCostMny = processCostMny;
    }

    public BigDecimal getProcessCostTaxMny() {
        return processCostTaxMny;
    }

    public void setProcessCostTaxMny(BigDecimal processCostTaxMny) {
        this.processCostTaxMny = processCostTaxMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getProcessReason() {
        return processReason;
    }

    public void setProcessReason(String processReason) {
        this.processReason = processReason;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getOutStoreNames() {
        return outStoreNames;
    }

    public void setOutStoreNames(String outStoreNames) {
        this.outStoreNames = outStoreNames;
    }

    public List<ProcessRawEntity> getProcessRawList() {
        return processRawList;
    }

    public void setProcessRawList(List<ProcessRawEntity> processRawList) {
        this.processRawList = processRawList;
    }

    public List<ProcessCostEntity> getProcessCostList() {
        return processCostList;
    }

    public void setProcessCostList(List<ProcessCostEntity> processCostList) {
        this.processCostList = processCostList;
    }

    public List<ProcessProductEntity> getProcessProductList() {
        return processProductList;
    }

    public void setProcessProductList(List<ProcessProductEntity> processProductList) {
        this.processProductList = processProductList;
    }
}
