package com.ejianc.business.outrmat.order.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 租赁订单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_outrmat_order")
public class OutRmatOrderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_id")
    private Long contractId; // 合同ID
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_rmat_method")
    private String contractRmatMethod; // 合同租赁方式(0-外租，1-内租)
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="supplier_id")
    private Long supplierId; // 设备供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="link_id")
    private Long linkId; // 联系人
    @TableField(value="link_name")
    private String linkName; // 联系人名称
    @TableField(value="link_telephone")
    private String linkTelephone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="order_expiry_date")
    private Date orderExpiryDate; // 要求到货日期
    @TableField(value="whether_prcing_materials")
    private String whetherPrcingMaterials; // 是否价拨材料(1-是，0-否)
    @TableField(value="order_note")
    private String orderNote; // 送货要求
    @TableField(value="order_address")
    private String orderAddress; // 送货地址
    @TableField(value="receive_state")
    private String receiveState; // 接收状态（1-全部接收，2-部分接受，3-不予接收）
    @TableField(value="deliver_state")
    private String deliverState; // 送货状态（1-待送货，2-全部送货，3-部分送货）
    @TableField(value="disable_state")
    private String disableState; // 是否关闭(1-是，0-否)
    @TableField(value="denial_reason")
    private String denialReason; // 拒绝原因
    @TableField(value="first_party_id")
    private Long firstPartyId; // 甲方Id
    @TableField(value="first_party_name")
    private String firstPartyName; // 甲方名称

    @TableField(value = "bill_push_flag")
    private String billPushFlag;// 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方

    /***  协同需要字段 START  ***/
    @TableField(value="sup_operator_name")
    private String supOperatorName; // 供方经办人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value="sup_operate_time")
    private Date supOperateTime; // 供方经办人签字时间
    @TableField(value="sup_operator_phone")
    private String supOperatorPhone; // 供方经办人手机号
    @TableField(value="sup_operator_user_code")
    private String supOperatorUserCode; // 供方经办人账号
    @TableField(exist = false)
    private Long supOperateFileId;// 供方经办人签字文件id
    @TableField(exist = false)
    private String sourceSystemId;// 来源业务系统id
    /***  协同需要字段 END  ***/


    @TableField(value="create_user_id")
    private Long createUserId; // 单据创建人ID
    @TableField(value="project_org_id")
    private Long projectOrgId; // 项目组织id
    @TableField(value="project_org_code")
    private String projectOrgCode; // 项目组织code
    @TableField(value="project_org_name")
    private String projectOrgName; // 项目组织name
    @TableField(value="project_dept_id")
    private Long projectDeptId; // 项目部门id
    @TableField(value="project_dept_code")
    private String projectDeptCode; // 项目部门code
    @TableField(value="project_dept_name")
    private String projectDeptName; // 项目部门name
    @TableField(value="rent_type")
    private String rentType; // 租赁方式



    @TableField(exist=false)
    @SubEntity(serviceName="outRmatOrderDetailService",pidName = "orderId")
    private List<OutRmatOrderDetailEntity> orderDetailList = new ArrayList<>(); // 租赁订单明细

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }

    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }

    public String getProjectOrgCode() {
        return projectOrgCode;
    }

    public void setProjectOrgCode(String projectOrgCode) {
        this.projectOrgCode = projectOrgCode;
    }

    public String getProjectOrgName() {
        return projectOrgName;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }

    public Long getProjectDeptId() {
        return projectDeptId;
    }

    public void setProjectDeptId(Long projectDeptId) {
        this.projectDeptId = projectDeptId;
    }

    public String getProjectDeptCode() {
        return projectDeptCode;
    }

    public void setProjectDeptCode(String projectDeptCode) {
        this.projectDeptCode = projectDeptCode;
    }

    public String getProjectDeptName() {
        return projectDeptName;
    }

    public void setProjectDeptName(String projectDeptName) {
        this.projectDeptName = projectDeptName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractRmatMethod() {
        return contractRmatMethod;
    }

    public void setContractRmatMethod(String contractRmatMethod) {
        this.contractRmatMethod = contractRmatMethod;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    public String getLinkTelephone() {
        return linkTelephone;
    }

    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    public String getWhetherPrcingMaterials() {
        return whetherPrcingMaterials;
    }

    public void setWhetherPrcingMaterials(String whetherPrcingMaterials) {
        this.whetherPrcingMaterials = whetherPrcingMaterials;
    }
    public String getOrderNote() {
        return orderNote;
    }

    public void setOrderNote(String orderNote) {
        this.orderNote = orderNote;
    }
    public String getOrderAddress() {
        return orderAddress;
    }

    public void setOrderAddress(String orderAddress) {
        this.orderAddress = orderAddress;
    }
    public String getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(String receiveState) {
        this.receiveState = receiveState;
    }
    public String getDeliverState() {
        return deliverState;
    }

    public void setDeliverState(String deliverState) {
        this.deliverState = deliverState;
    }
    public String getDisableState() {
        return disableState;
    }

    public void setDisableState(String disableState) {
        this.disableState = disableState;
    }
    public String getDenialReason() {
        return denialReason;
    }

    public void setDenialReason(String denialReason) {
        this.denialReason = denialReason;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }


    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    

    public List<OutRmatOrderDetailEntity> getOrderDetailList() {
        return orderDetailList;
    }

    public void setOrderDetailList(List<OutRmatOrderDetailEntity> orderDetailList) {
        this.orderDetailList = orderDetailList;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
}
