package com.ejianc.business.assist.store.controller;

import java.io.Serializable;

import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.service.IProcessService;

/**
 * 原材料加工
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("process")
public class ProcessController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "STORE_PROCESS";//此处需要根据实际修改

    @Autowired
    private IProcessService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    StoreManageService storeManageService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProcessVO> saveOrUpdate(@RequestBody ProcessVO saveOrUpdateVO) {
    	ProcessEntity entity = BeanMapper.map(saveOrUpdateVO, ProcessEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	if (entity.getCostTaxMny() != null && entity.getProcessCostTaxMny() != null){
            if ((entity.getCostTaxMny()).compareTo(entity.getProcessCostTaxMny()) == -1){
                return CommonResponse.error("成品金额小于加工成本金额不可保存单据！");
            }
        }
        // 汇总出库仓库
        List<ProcessRawVO> detailList = saveOrUpdateVO.getProcessRawList();
        String outStoreNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getStoreName())).map(x->x.getStoreName()).distinct().collect(Collectors.joining(","));
        entity.setOutStoreNames(outStoreNames);
        CommonResponse commonResponse = service.saveCheckProcess(entity);
        if(!commonResponse.isSuccess()){
            return commonResponse;
        }
    	ProcessVO vo = BeanMapper.map(entity, ProcessVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProcessVO> queryDetail(Long id) {
    	ProcessEntity entity = service.selectById(id);
    	ProcessVO vo = BeanMapper.map(entity, ProcessVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProcessVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProcessVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.myRemoveByIds(vos.stream().map(ProcessVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProcessVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "orgName","employeeName","outStoreNames"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        if(!param.getParams().containsKey("orgId")){// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        } else if (param.getParams().get("orgId").getValue() != null){ // 移动端默认项目、默认组织
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProcessEntity> page = service.queryPage(param,false);
        IPage<ProcessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProcessVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProcessEntity> list = service.queryList(param);
        List<ProcessVO> processVOS = BeanMapper.mapList(list, ProcessVO.class);
        processVOS.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", processVOS);
        ExcelExport.getInstance().export("processExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProcessData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProcessVO>> refProcessData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProcessEntity> page = service.queryPage(param,false);
        IPage<ProcessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProcessVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    //获取原值/净值
    @RequestMapping(value = "/getMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UseMaterialPriceVO>> getMaterialPrice(@RequestBody ProcessVO vo){
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<FlowVO> flowVOS = new ArrayList<>();
        storeManageVO.setStoreId(vo.getStoreId());
        if (vo.getId() != null){
            storeManageVO.setSourceId(vo.getId());
        }
        vo.getProcessRawList().forEach(e->{
            FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.原材料加工出库, 0);
            flowVO.setStoreId(vo.getStoreId());
            flowVO.setStoreName(vo.getStoreName());
            flowVO.setOrgId(vo.getOrgId());
            flowVO.setOrgName(vo.getOrgName());
            flowVO.setParentOrgId(vo.getParentOrgId());
            flowVO.setParentOrgName(vo.getParentOrgName());
            flowVO.setEmployeeId(vo.getEmployeeId());
            flowVO.setEmployeeName(vo.getEmployeeName());
            flowVO.setMaterialCategoryId(e.getMaterialTypeId());
            flowVO.setMaterialCategoryName(e.getMaterialTypeName());
            flowVO.setMaterialId(e.getMaterialId());
            flowVO.setMaterialName(e.getMaterialName());
            flowVO.setMaterialSpec(e.getSpec());
            flowVO.setMaterialUnitId(e.getUnitId());
            flowVO.setMaterialUnitName(e.getUnitName());
            flowVO.setNum(e.getRawNum());
            flowVO.setSourceDetailId(e.getId());
            flowVO.setSourceBillCode(vo.getBillCode());
            flowVO.setSourceBillDate(vo.getProcessDate());
            flowVO.setRowState(e.getRowState());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        List<UseMaterialPriceVO> list = new ArrayList<>();
        CommonResponse<StoreManageVO> response = storeManageService.turnSurplusMaterialPrice(storeManageVO);
        if (response.getData() != null){
            list = response.getData().getUseMaterialPriceVOList();
            return CommonResponse.success("原值单价/净值获取成功",list);
        }
        return CommonResponse.success(response.getMsg());
    }
}
