package com.ejianc.business.outrmat.lose.service;

import com.ejianc.business.assist.store.vo.AllotOutVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 遗失单
 * 
 * @author generator
 * 
 */
public interface IOutRmatLoseService extends IBaseService<OutRmatLoseEntity> {

    List<StoreManageVO> getStoreManageVOList(OutRmatLoseVO vo ,Boolean outEffectiveON);

    OutRmatLoseVO saveOrUpdate(OutRmatLoseVO saveOrUpdateVO);

    void delete( List<OutRmatLoseVO> vos);

    String validateContract(Long contractId, Long billId);

    String validateTime(OutRmatLoseVO saveOrUpdateVO, String type);

    /**
     * 单据推送到供方协同服务
     *
     * @param entity 待推送单据
     * @return
     */
    boolean pushBillToSupCenter(OutRmatLoseEntity entity);

    /**
     * 同步单据供应商签字信息
     *
     * @param map
     */
    String updateBillSupSignSyncInfo(Map<String,String> map);

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    boolean delPushBill(OutRmatLoseEntity entity);
}
