package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.material.bean.*;
import com.ejianc.business.assist.material.consts.MaterialConstant;
import com.ejianc.business.assist.material.enums.BillTypeEnum;
import com.ejianc.business.assist.material.mapper.MaterialChangeMapper;
import com.ejianc.business.assist.material.service.*;
import com.ejianc.business.assist.material.vo.*;
import com.ejianc.business.assist.material.vo.compare.MaterialChangeCompareVO;
import com.ejianc.business.assist.material.vo.record.MaterialChangeRecordVO;
import com.ejianc.business.assist.rmat.enums.*;
import com.ejianc.business.assist.rmat.vo.ChangePaymentVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 辅料中心采购合同-变更表
 * 
 * @author generator
 * 
 */
@Service("materialChangeService")
public class MaterialChangeServiceImpl extends BaseServiceImpl<MaterialChangeMapper, MaterialChangeEntity> implements IMaterialChangeService{
    
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ASSISTMATERIAL_CONTRACT_CHANGE";//此处需要根据实际修改

    @Autowired
    private IAttachmentApi attachmentApi;
    
    @Autowired
    private IMaterialContractService contractService;

    @Autowired
    private IMaterialRecordService recordService;

    @Autowired
    private IMaterialContractDetailService detailService;

    @Autowired
    private IMaterialContractOtherService otherService;

    @Autowired
    private IMaterialContractPaymentService paymentService;

    @Autowired
    private IMaterialContractClauseService clauseService;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IMaterialContractFileService fileService;


    @Override
    public MaterialChangeVO saveOrUpdate(MaterialChangeVO saveOrUpdateVO) {
        // 获取主合同当前合同文件Id
        MaterialContractEntity contractEntity = contractService.selectById(saveOrUpdateVO.getMainContractId());
        // 将主合同原合同文件从attachId中删除，否改文件会被该写到变更合同中
        if(ListUtil.isNotEmpty(saveOrUpdateVO.getAttachIds()) &&  null != contractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(contractEntity.getContractFileId());
        }

        MaterialChangeEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialChangeEntity.class);
        
        if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }

            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());

            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                // 第一次变更
                entity.setChangeVersion(1);
            } else {
                // 版本号+1
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }

            if(entity.getChangeVersion() < 10){
                entity.setBillCode(entity.getMainContractCode() + "-1-" + "0" + entity.getChangeVersion());
            } else {
                entity.setBillCode(entity.getMainContractCode() + "-1-" + entity.getChangeVersion());
            }

            // 清空字表id、复制sourceBid
            clearDetailList(entity);
            
        }

        contractService.validateContract(saveOrUpdateVO.getMainContractId(), MaterialConstant.变更单, saveOrUpdateVO.getId(), MaterialConstant.保存);

        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setChangeContractName(entity.getContractName());
        this.saveOrUpdate(entity, false);

        // 回写主合同信息
        LambdaUpdateWrapper<MaterialContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(MaterialContractEntity::getChangeId, entity.getId());
        updateWrapper.set(MaterialContractEntity::getChangingMny, entity.getContractMny());
        updateWrapper.set(MaterialContractEntity::getChangingTaxMny, entity.getContractTaxMny());
        updateWrapper.set(MaterialContractEntity::getChangeCode, entity.getBillCode());
        updateWrapper.set(MaterialContractEntity::getChangeVersion, entity.getChangeVersion());
        updateWrapper.set(MaterialContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(MaterialContractEntity::getChangeDate, entity.getChangeDate());
        updateWrapper.set(MaterialContractEntity::getChangeDraftType, entity.getChangeDraftType());
        updateWrapper.set(MaterialContractEntity::getChangeContractSignatureStatus, entity.getSignatureStatus());
        updateWrapper.set(MaterialContractEntity::getChangeFileId, entity.getChangeFileId());
        updateWrapper.set(MaterialContractEntity::getChangeContractName, entity.getContractName());
        updateWrapper.eq(MaterialContractEntity::getId, entity.getMainContractId());
        contractService.update(updateWrapper);
        
        return BeanMapper.map(this.selectById(entity.getId()), MaterialChangeVO.class);
    }

    @Override
    public void deleteByIds(List<MaterialChangeVO> vos) {
        for (MaterialChangeVO vo : vos) {
            MaterialChangeEntity changeEntity = super.selectById(vo.getId());
            
            LambdaUpdateWrapper<MaterialContractEntity> lambdaUpdate = new LambdaUpdateWrapper<>();
            if (changeEntity.getChangeVersion() == 1) {
                lambdaUpdate.set(MaterialContractEntity::getChangeStatus, 1);
            } else {
                lambdaUpdate.set(MaterialContractEntity::getChangeStatus, 3);
            }
            lambdaUpdate.eq(MaterialContractEntity::getId, changeEntity.getContractId());
            contractService.update(lambdaUpdate);

            super.removeById(vo, false);
        }
    }

    @Override
    public MaterialChangeRecordVO queryChangeRecord(Long id) {
        MaterialContractEntity entity = contractService.selectById(id);

        MaterialChangeRecordVO vo = new MaterialChangeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setBaseMny(entity.getBaseMny());
        vo.setBaseTaxMny(entity.getBaseTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());

        // 查询变更记录
        LambdaQueryWrapper<MaterialChangeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(MaterialChangeEntity::getContractId, id);
        wrapper.orderByDesc(MaterialChangeEntity::getCreateTime);
        List<MaterialChangeEntity> changeList = super.list(wrapper);

        vo.setTotalChangeMny(ComputeUtil.safeSub(vo.getContractMny(), vo.getBaseMny()));
        vo.setTotalChangeTaxMny(ComputeUtil.safeSub(vo.getContractTaxMny(), vo.getBaseTaxMny()));
        vo.setTotalChangeNum(changeList.size());
        vo.setTotalChangeRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getTotalChangeMny(), vo.getBaseTaxMny()), new BigDecimal("100")));

        vo.setDetailList(BeanMapper.mapList(changeList, MaterialChangeVO.class));

        return vo;
    }

    @Override
    public MaterialChangeVO queryContractRecordDetail(Long id) {
        LambdaQueryWrapper<MaterialRecordEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(MaterialRecordEntity::getChangeId, id);
        List<MaterialRecordEntity> list = recordService.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            return BeanMapper.map(recordService.selectById(list.get(0).getId()), MaterialChangeVO.class);
        }else {
            return new MaterialChangeVO();
        }
    }

    /**
     * 变更通过审批后回写方法
     * @param changeBillId
     * @param billTypeCode
     * @param commitState
     * @return
     */
    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        // 表更表
        MaterialChangeEntity changeEntity = this.selectById(changeBillId);
        // 原合同数据
        MaterialContractVO contractVO = contractService.queryDetail(changeEntity.getContractId());

        // 回写记录表数据
        writeBackRecord(changeEntity, contractVO);

        // 回写原合同数据
        writeBackContract(changeEntity, contractVO);


        // 设置变更合同生效状态
        changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
        changeEntity.setCommitDate(new Date());

        // 变更单更新
        this.saveOrUpdate(changeEntity);

        if (DraftTypeEnum.线上起草.getCode().equals(changeEntity.getChangeDraftType()) || DraftTypeEnum.上传合同.getCode().equals(changeEntity.getChangeDraftType())){
            // 更新合同的 签章文件id
            fileService.getSignedFileInfo(changeBillId, "contractChange");
        }

        return CommonResponse.success("变更单生效，回写合同成功！");

    }

    /**
     * 推送合同池
     * @param vo
     * @param updateLevel
     * @return
     */
    @Override
    public Boolean pushContract(MaterialContractVO vo, String updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            // 删除原单据
            contractService.delContractFromPool(vo.getId());

            BeanConvertorUtil.convert(vo, data);
            data.setSourceType(ContractTypeEnum.辅料中心周转材采购合同.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.支出.getCode()));

            // 合同累计变更金额
            MaterialChangeRecordVO changeRecordVO = queryChangeRecord(vo.getId());
            data.setTotalChangeMny(changeRecordVO.getTotalChangeMny());
            data.setTotalChangeTaxMny(changeRecordVO.getTotalChangeTaxMny());
            data.setTotalChangeTax(ComputeUtil.safeSub(data.getTotalChangeTaxMny(), data.getTotalChangeMny()));
            data.setTaotalChangeScale(changeRecordVO.getTotalChangeRate());

            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }

        return null;
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        /*
            当前变更合同如果未提交，则和主合同对比
            如果提交，则和合同记录表对比
         */
        MaterialChangeEntity changeEntity = this.selectById(id);
        MaterialChangeCompareVO changeCompareVO = BeanMapper.map(changeEntity, MaterialChangeCompareVO.class);
        MaterialContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());

        MaterialChangeCompareVO beforeChangeVO = new MaterialChangeCompareVO();
        boolean flag = false;
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            // 若变更单已审批通过，则查询最新的合同记录
            LambdaQueryWrapper<MaterialRecordEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(MaterialRecordEntity::getChangeId, id);
            wrapper.eq(MaterialRecordEntity::getContractId, changeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);

            List<MaterialRecordEntity> recordEntityList = recordService.list(wrapper);
            if (ListUtil.isNotEmpty(recordEntityList)) {
                beforeChangeVO = BeanMapper.map(recordService.selectById(recordEntityList.get(0).getId()), MaterialChangeCompareVO.class);
            }
        }else {
            beforeChangeVO = BeanMapper.map(contractEntity, MaterialChangeCompareVO.class);
            flag = true;
        }

        Map<String, Object> returnMap = new HashMap<>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            // 材料清单
            if (ListUtil.isNotEmpty(changeCompareVO.getDetailList())) {
                List<MaterialChangeDetailVO> detailList = beforeChangeVO.getDetailList();
                Map<Long, MaterialChangeDetailVO> beforeDetailMap = new HashMap<>();
                if (flag) {
                    beforeDetailMap = detailList.stream().collect(Collectors.toMap(MaterialChangeDetailVO::getId, Function.identity()));
                }else {
                    beforeDetailMap = detailList.stream().collect(Collectors.toMap(MaterialChangeDetailVO::getSourceBid, Function.identity()));
                }

                for (MaterialChangeDetailVO vo : changeCompareVO.getDetailList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        MaterialChangeDetailVO beforeVO = beforeDetailMap.get(vo.getSourceBid());
                        vo.setBcBrand(beforeVO.getBrand());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                        vo.setBcUnitName(beforeVO.getUnitName());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcTaxMny(beforeVO.getTaxMny());
                        vo.setBcMemo(beforeVO.getMemo());
                    }
                }

                changeCompareVO.setDetailList(changeCompareVO.getDetailList().stream().filter(daily -> StringUtils.isNotEmpty(daily.getChangeType())).collect(Collectors.toList()));
            }
            

            // 其他
            if (ListUtil.isNotEmpty(changeCompareVO.getOtherList())) {
                List<MaterialChangeOtherVO> otherList = beforeChangeVO.getOtherList();
                Map<Long, MaterialChangeOtherVO> beforeOtherMap = new HashMap<>();
                if (flag) {
                    beforeOtherMap = otherList.stream().collect(Collectors.toMap(MaterialChangeOtherVO::getId, Function.identity()));
                }else {
                    beforeOtherMap = otherList.stream().collect(Collectors.toMap(MaterialChangeOtherVO::getSourceBid, Function.identity()));
                }
                for (MaterialChangeOtherVO vo : changeCompareVO.getOtherList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        MaterialChangeOtherVO beforeVO = beforeOtherMap.get(vo.getSourceBid());
                        vo.setBcCostName(beforeVO.getCostName());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(BigDecimal.ZERO);
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcMemo(beforeVO.getMemo());
                    }
                }

                changeCompareVO.setOtherList(changeCompareVO.getOtherList().stream().filter(other -> StringUtils.isNotEmpty(other.getChangeType())).collect(Collectors.toList()));
            }

            // 设置合同付款阶段
            List<MaterialChangePaymentVO> newPayList = new ArrayList<>();
            Map<Long, MaterialChangePaymentVO> beforePayMap = new HashMap<>();
            if (flag) {
                beforePayMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(MaterialChangePaymentVO::getId, item -> item, (v1, v2) -> v2));
            }else {
                beforePayMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(MaterialChangePaymentVO::getSourceBid, item -> item, (v1, v2) -> v2));
            }
            if (ListUtil.isNotEmpty(changeCompareVO.getPaymentList())) {
                MaterialChangePaymentVO beforeVo = null;
                for (MaterialChangePaymentVO vo : changeCompareVO.getPaymentList()) {
                    if (vo.getSourceBid() == null) {
                        //没有来源则说明为新增项
                        vo.setChangeType(MaterialConstant.CHANGE_TYPE_ADD.toString());
                        newPayList.add(vo);
                    } else if (beforePayMap.containsKey(vo.getSourceBid())) {
                        beforeVo = beforePayMap.get(vo.getSourceBid());
                        if (!beforeVo.getPaymentName().equals(vo.getPaymentName()) || !beforeVo.getPaymentScale().equals(vo.getPaymentScale())) {
                            vo.setBcPaymentName(beforeVo.getPaymentName());
                            vo.setBcPaymentScale(beforeVo.getPaymentScale());
                            vo.setChangeType(MaterialConstant.CHANGE_TYPE_CONTENT_CHANGE.toString());
                            newPayList.add(vo);
                        }
                        beforePayMap.remove(vo.getSourceBid());
                    }
                }
            }
            if(MapUtils.isNotEmpty(beforePayMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                beforePayMap.values().forEach(c -> {
                    c.setChangeType(MaterialConstant.CHANGE_TYPE_DEL.toString());
                    newPayList.add(c);
                });
            }
            changeCompareVO.setPaymentList(newPayList);

            //设置合同条款
            List<MaterialChangeClauseVO> newClauses = new ArrayList<>();
            Map<Long, MaterialChangeClauseVO> beforeClauseMap = new HashMap<>();
            if (flag) {
                beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(MaterialChangeClauseVO::getId, clause -> clause, (v1,v2) ->v2));
            }else {
                beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(MaterialChangeClauseVO::getSourceBid, clause -> clause, (v1,v2) ->v2));
            }
            if(ListUtil.isNotEmpty(changeCompareVO.getClauseList())) {
                MaterialChangeClauseVO beforeVo = null;
                for (MaterialChangeClauseVO vo : changeCompareVO.getClauseList()) {
                    if(vo.getSourceBid() == null) {
                        // 没有来源则说明为新增项
                        vo.setChangeType(MaterialConstant.CHANGE_TYPE_ADD.toString());
                        newClauses.add(vo);
                    } else if(beforeClauseMap.containsKey(vo.getSourceBid())) {
                        beforeVo = beforeClauseMap.get(vo.getSourceBid());
                        if (!Objects.equals(beforeVo.getClauseNameId(), vo.getClauseNameId()) || !Objects.equals(beforeVo.getClauseContent(), vo.getClauseContent())) {
                            // 参照变更
                            vo.setBcClauseName(beforeVo.getClauseName());
                            vo.setBcClauseContent(beforeVo.getClauseContent());
                            vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                            newClauses.add(vo);
                        }

                        beforeClauseMap.remove(vo.getSourceBid());
                    }
                }
            }
            if(MapUtils.isNotEmpty(beforeClauseMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                beforeClauseMap.values().forEach(c -> {
                    c.setChangeType(MaterialConstant.CHANGE_TYPE_DEL.toString());
                    newClauses.add(c);
                });
            }
            changeCompareVO.setClauseList(newClauses);
            
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }

        return returnMap;
    }

    /**
     * 回写记录表数据
     * @param changeEntity
     * @param contractVO
     */
    public void writeBackRecord(MaterialChangeEntity changeEntity, MaterialContractVO contractVO) {
        // 同步原合同到记录表
        MaterialRecordEntity recordEntity = BeanMapper.map(contractVO, MaterialRecordEntity.class);
        recordEntity.setContractId(changeEntity.getContractId());
        recordEntity.setId(null);

        // 历史记录子表处理
        if(ListUtil.isNotEmpty(recordEntity.getDetailList())){
            for (MaterialRecordDetailEntity entity : recordEntity.getDetailList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        
        if(ListUtil.isNotEmpty(recordEntity.getOtherList())){
            for (MaterialRecordOtherEntity entity : recordEntity.getOtherList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(recordEntity.getClauseList())){
            for (MaterialRecordClauseEntity entity : recordEntity.getClauseList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(recordEntity.getPaymentList())){
            for (MaterialRecordPaymentEntity entity : recordEntity.getPaymentList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }

        recordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");

        // 原合同附件、起草附件同步到记录单据中
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(contractVO.getId()), BillTypeEnum.辅料中心采购合同.getCode(), MaterialConstant.CONTRACT_ATTACH_SOURCE_TYPE,
                String.valueOf(recordEntity.getId()), BillTypeEnum.辅料中心采购合同记录.getCode(), MaterialConstant.CONTRACT_RECORD_ATTACH_SOURCE_TYPE);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));

        logger.info("同步附件");
        CommonResponse<String> response2 = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(contractVO.getId()), BillTypeEnum.辅料中心采购合同.getCode(), MaterialConstant.CONTRACT_FILE_SOURCE_TYPE,
                String.valueOf(recordEntity.getId()), BillTypeEnum.辅料中心采购合同记录.getCode(), MaterialConstant.CONTRACT_RECORD_FILE_SOURCE_TYPE);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response2));

    }

    /**
     * 回写原合同数据
     * @param changeEntity
     * @param contractVO
     */
    public void writeBackContract(MaterialChangeEntity changeEntity, MaterialContractVO contractVO) {
        MaterialContractEntity contractEntity = BeanMapper.map(contractVO, MaterialContractEntity.class);

        // 甲方、乙方信息
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyEmployeeId(changeEntity.getFirstPartyEmployeeId());
        contractEntity.setFirstPartyEmployeeName(changeEntity.getFirstPartyEmployeeName());
        contractEntity.setFirstPartyPhone(changeEntity.getFirstPartyPhone());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierEmployeeId(changeEntity.getSupplierEmployeeId());
        contractEntity.setSupplierEmployeeName(changeEntity.getSupplierEmployeeName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        
        
        contractEntity.setFirstPartyEntrustedAgentId(changeEntity.getFirstPartyEntrustedAgentId());
        contractEntity.setFirstPartyEntrustedAgentName(changeEntity.getFirstPartyEntrustedAgentName());
        
        // 合同金额、清单金额、其他费用
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        contractEntity.setDetailTaxMny(changeEntity.getDetailTaxMny());
        contractEntity.setDetailMny(changeEntity.getDetailMny());
        contractEntity.setDetailTax(changeEntity.getDetailTax());
        contractEntity.setOtherTaxMny(changeEntity.getOtherTaxMny());
        contractEntity.setOtherMny(changeEntity.getOtherMny());
        contractEntity.setOtherTax(changeEntity.getOtherTax());
        
        
        // 其他业务字段
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setChangeContractName(changeEntity.getContractName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignAddress(changeEntity.getSignAddress());
        contractEntity.setReceiptAddress(changeEntity.getReceiptAddress());
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        contractEntity.setChangeContractSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
        contractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        contractEntity.setChangeFileId(changeEntity.getChangeFileId());

        // 回写原合同子表信息
        if (ListUtil.isNotEmpty(contractVO.getDetailList())) {
            detailService.removeByIds(contractVO.getDetailList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<MaterialContractDetailEntity> detailList = BeanMapper.mapList(changeEntity.getDetailList(), MaterialContractDetailEntity.class);
        if (ListUtil.isNotEmpty(detailList)) {
            for (MaterialContractDetailEntity entity : detailList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setDetailList(detailList);
        
        // 其他费用
        if (ListUtil.isNotEmpty(contractVO.getOtherList())) {
            otherService.removeByIds(contractVO.getOtherList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<MaterialContractOtherEntity> otherList = BeanMapper.mapList(changeEntity.getOtherList(), MaterialContractOtherEntity.class);
        if (ListUtil.isNotEmpty(otherList)) {
            for (MaterialContractOtherEntity entity : otherList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setOtherList(otherList);

        // 付款计划
        if (ListUtil.isNotEmpty(contractVO.getPaymentList())) {
            paymentService.removeByIds(contractVO.getPaymentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<MaterialContractPaymentEntity> paymentList = BeanMapper.mapList(changeEntity.getPaymentList(), MaterialContractPaymentEntity.class);
        if (ListUtil.isNotEmpty(paymentList)) {
            for (MaterialContractPaymentEntity entity : paymentList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setPaymentList(paymentList);

        // 条款
        if (ListUtil.isNotEmpty(contractVO.getClauseList())) {
            clauseService.removeByIds(contractVO.getClauseList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<MaterialContractClauseEntity> clauseList = BeanMapper.mapList(changeEntity.getClauseList(), MaterialContractClauseEntity.class);
        if (ListUtil.isNotEmpty(clauseList)) {
            for (MaterialContractClauseEntity entity : clauseList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setClauseList(clauseList);

        // 更新合同池操作
        Boolean pushResult = this.pushContract(BeanMapper.map(contractEntity, MaterialContractVO.class), UpdateLevelEnum.全量覆盖更新.getLevelCode());
        if(pushResult) {
            contractEntity.setPushPoolFlag(BillPushStatusEnum.推送成功.getStatus());
        } else {
            contractEntity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        
        contractService.saveOrUpdate(contractEntity, false);

        // 同步附件管理（不包含变更附件）到原合同
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(changeEntity.getId()), BillTypeEnum.辅料中心采购合同变更.getCode(), MaterialConstant.CONTRACT_CHANGE_ATTACH_SOURCE_TYPE,
                String.valueOf(contractEntity.getId()), BillTypeEnum.辅料中心采购合同.getCode(), MaterialConstant.CONTRACT_ATTACH_SOURCE_TYPE);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));

    }


    
    public void clearDetailList(MaterialChangeEntity changeEntity) {
        // 明细
        if(ListUtil.isNotEmpty(changeEntity.getDetailList())){
            for (MaterialChangeDetailEntity entity : changeEntity.getDetailList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
      
        // 其他费用
        if(ListUtil.isNotEmpty(changeEntity.getOtherList())){
            for (MaterialChangeOtherEntity entity : changeEntity.getOtherList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 付款计划
        if(ListUtil.isNotEmpty(changeEntity.getPaymentList())){
            for (MaterialChangePaymentEntity entity : changeEntity.getPaymentList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 合同条款
        if(ListUtil.isNotEmpty(changeEntity.getClauseList())){
            for (MaterialChangeClauseEntity entity : changeEntity.getClauseList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
    }
    
    






}
