package com.ejianc.business.assist.report.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.assist.report.bean.MonthReportEntity;
import com.ejianc.business.assist.report.service.IMonthReportService;
import com.ejianc.business.assist.report.vo.MonthReportVO;

/**
 * 自有周转材月报表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("monthReport")
public class MonthReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMonthReportService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthReportVO> saveOrUpdate(@RequestBody MonthReportVO saveOrUpdateVO) {
    	MonthReportEntity entity = BeanMapper.map(saveOrUpdateVO, MonthReportEntity.class);
    	service.saveOrUpdate(entity, false);
    	MonthReportVO vo = BeanMapper.map(entity, MonthReportVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthReportVO> queryDetail(Long id) {
    	MonthReportEntity entity = service.selectById(id);
    	MonthReportVO vo = BeanMapper.map(entity, MonthReportVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthReportVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MonthReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MonthReportVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthReportVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter materialTypeId = param.getParams().get("materialTypeId");
        if(null!=materialTypeId){
            CommonResponse<List<MaterialCategoryVO>> response =  shareMaterialApi.queryCategoryListByPid(Long.valueOf(materialTypeId.getValue().toString()));
            if(null!=response.getData()){
                List<Long> typeIds =  response.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
                param.getParams().put("materialTypeId",new Parameter(QueryParam.IN,typeIds));
            }
        }
        IPage<MonthReportEntity> page = service.queryPage(param,false);
        IPage<MonthReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthReportVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        Parameter materialTypeId = param.getParams().get("materialTypeId");
        if(null!=materialTypeId){
            CommonResponse<List<MaterialCategoryVO>> res =  shareMaterialApi.queryCategoryListByPid(Long.valueOf(materialTypeId.getValue().toString()));
            if(null!=res.getData()){
                List<Long> typeIds =  res.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
                param.getParams().put("materialTypeId",new Parameter(QueryParam.IN,typeIds));
            }
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<MonthReportEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MonthReport-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refMonthReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthReportVO>> refMonthReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MonthReportEntity> page = service.queryPage(param,false);
        IPage<MonthReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthReportVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     /*
      * @Description  定时任务生成数据
     */
    @RequestMapping(value = "/pushMonthReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> pushMonthReport(HttpServletRequest request) {
//        String param = request.getParameter("param");
//        JSONArray json = JSONArray.parseArray(param);
//        logger.info("生成自有周转材月报表 定时任务开始：" + param + "----");
        service.saveMonthReport();
        return CommonResponse.success("定时任务处理成功");
    }


    /*
     * @Description  定时任务生成数据
     */
    @RequestMapping(value = "/pushMonthReport2", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushMonthReport2() {
//        String param = request.getParameter("param");
//        JSONArray json = JSONArray.parseArray(param);
//        logger.info("生成自有周转材月报表 定时任务开始：" + param + "----");
        service.saveMonthReport();
        return CommonResponse.success("定时任务处理成功");
    }
}
