package com.ejianc.business.assist.rmat.mapper;

import com.ejianc.business.assist.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractNumRentEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 周转材租赁合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface ContractMapper extends BaseCrudMapper<ContractEntity> {

    @Select("select * from ejc_assistrmat_contract where dr = 0 and create_time >= #{time} or update_time >= #{time}")
    List<ContractEntity> getContractListByTime(Date qDate);

    @Select({
            "<script>",
            "select * from ejc_assistrmat_contract_daily_rent where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<ContractDailyRentEntity> getContractDayDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    @Select({
            "<script>",
            "select * from ejc_assistrmat_contract_month_rent where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<ContractMonthRentEntity> getContractMonDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    @Select({
            "<script>",
            "select * from ejc_assistrmat_contract_num_rent where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<ContractNumRentEntity> getContractNumDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);
}
