package com.ejianc.business.outrmat.api;

import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.pro.pricelib.vo.PriceContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/api/assistRmatOut/")
public class AssistRmatOutContractApi {

    @Autowired
    private IOutRmatContractService service;

    /**
     * 查询周转材价格库所需-辅料周转才-租出合同-数据
     * @param initFlag
     * @return
     */
    @GetMapping(value = "getPriceContractDataByAssistRmatOut")
    CommonResponse<List<PriceContractVO>> getPriceContractDataByAssistRmatOut(@RequestParam(value = "initFlag") String initFlag){
        List<PriceContractVO> priceContractList = service.queryPriceContractDataByAssistRmatOut(initFlag);
        return CommonResponse.success("查询周转材价格库所需-辅料周转才-租出合同-数据结束！", priceContractList);
    }
}
