package com.ejianc.business.outrmat.contract.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.RmatFlowEntity;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.MaterialStateEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.ListCallable;
import com.ejianc.business.assist.rmat.vo.*;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateEntity;
import com.ejianc.business.outrmat.calculate.service.IOutRmatCalculateService;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.mapper.OutRmatMaterialMapper;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteDetailEntity;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteDetailService;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.start.bean.OutRmatStartEntity;
import com.ejianc.business.outrmat.start.service.IOutRmatStartService;
import com.ejianc.business.outrmat.stop.bean.OutRmatStopEntity;
import com.ejianc.business.outrmat.stop.service.IOutRmatStopService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料公共接口
 *
 * @author generator
 *
 */
@Service("outRmatMaterialService")
public class OutRmatMaterialServiceImpl implements IOutRmatMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutRmatDeliveryService outRmatDeliveryService;

    @Autowired
    private IOutRmatStartService outRmatStartService;

    @Autowired
    private IOutRmatStopService outRmatStopService;

    @Autowired
    private IOutRmatRestituteService outRmatRestituteService;
    @Autowired
    private IOutRmatRestituteDetailService outRestDetailService;

    @Autowired
    private IOutRmatLoseService outRmatLoseService;

    @Autowired
    private IOutRmatCalculateService rentService;

    @Autowired
    private OutRmatMaterialMapper baseMapper;
    @Autowired
    private IRmatFlowService flowService;

    @Override
    public List<MaterialVO> queryCheckList(QueryParam param, String type) {
        if("report".equals(type)){
            param.getFuzzyFields().add("contractName");
            param.getFuzzyFields().add("supplierName");
            param.getFuzzyFields().add("billCode");
        }
        param.getFuzzyFields().add("materilCode");
        param.getFuzzyFields().add("materilName");
        param.getFuzzyFields().add("spec");
        List<RmatFlowEntity> flowList = flowService.queryList(param, false);

        List<RmatFlowEntity> checkList = new ArrayList<>();// 验收单
        List<RmatFlowEntity> startList = new ArrayList<>();// 启用单
        List<RmatFlowEntity> stopList = new ArrayList<>();// 停用单
        List<RmatFlowEntity> restList = new ArrayList<>();// 退赔单
        List<RmatFlowEntity> loseList = new ArrayList<>();// 遗失单
        List<RmatFlowEntity> tempRestList = new ArrayList<>();// 未生效退赔单
        List<RmatFlowEntity> tempLoseList = new ArrayList<>();// 未生效遗失单
        for(RmatFlowEntity flow : flowList){
            if(RmatCommonConsts.YES.equals(flow.getEffectiveState())){
                if(BillTypeEnum.租出出库单.getCode().equals(flow.getBillTypeCode())){
                    checkList.add(flow);
                }
                if(BillTypeEnum.辅料中心租出停用单.getCode().equals(flow.getBillTypeCode())){
                    stopList.add(flow);
                }
                if(BillTypeEnum.辅料中心租出启用单.getCode().equals(flow.getBillTypeCode())){
                    startList.add(flow);
                }
                if(BillTypeEnum.租出退赔单.getCode().equals(flow.getBillTypeCode())){
                    restList.add(flow);
                }
                if(BillTypeEnum.租出遗失单.getCode().equals(flow.getBillTypeCode())){
                    loseList.add(flow);
                }
            }
            if(RmatCommonConsts.NO.equals(flow.getEffectiveState())){
                if(BillTypeEnum.租出退赔单.getCode().equals(flow.getBillTypeCode())){
                    tempRestList.add(flow);
                }
                if(BillTypeEnum.租出遗失单.getCode().equals(flow.getBillTypeCode())){
                    tempLoseList.add(flow);
                }
            }
        }
        // 租出退赔单完好/维修/报废数量
        List<Long> restIds = restList.stream().map(RmatFlowEntity::getSourceDetailId).collect(Collectors.toList());
        List<Long> tempRestIds = tempRestList.stream().map(RmatFlowEntity::getSourceDetailId).collect(Collectors.toList());
        restIds.addAll(tempRestIds);
        List<OutRmatRestituteDetailEntity> outRestDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(restIds)){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, restIds));
            outRestDetailList = outRestDetailService.queryList(queryParam);
        }
        Map<Long, OutRmatRestituteDetailEntity> outRestDetailMap = outRestDetailList.stream().collect(
                Collectors.toMap(OutRmatRestituteDetailEntity::getId, Function.identity(),(t1,t2)->t2));
        if(MapUtils.isEmpty(outRestDetailMap)){
            outRestDetailMap = new HashMap<>();
        }

        Map<String, MaterialVO> map = new HashMap<>();// key-合同主键+物料主键+计组方式+使用状态+转换系数，value-物料
        String key = null;
        for(RmatFlowEntity detail: checkList){// 验收单
            for(int i = 0; i< 2; i++){// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i + "|" + detail.getTransScale();
                MaterialVO vo = new MaterialVO();
                if(!map.containsKey(key)){
                    vo.setId(key);
                    // 转换材料明细信息
                    this.transferVO(detail, vo);
                    vo.setUseStatus(String.valueOf(i));
                } else {
                    vo = map.get(key);
                }
                // 已进场
                vo.setCheckedNum(ComputeUtil.safeAdd(vo.getCheckedNum(), detail.getNum()));
                // 已启用 = 已进场
                vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getNum()));
                // 辅数量(停用状态物料初始辅数量应为0)
                if(i == 1){
                    vo.setAssistNum(ComputeUtil.safeAdd(vo.getAssistNum(), detail.getAssistNum()));
                }
                map.put(key, vo);
            }
        }
        for(RmatFlowEntity detail: startList){// 启用单
            for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i + "|" + detail.getTransScale();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                if (i == 0){// 已停用 = 已停用 - 已启用
                    vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getNum()));
                    // 停用单辅数量 = 停用单辅数量 - 启用单辅数量
                    vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
                } else {// 已启用
                    vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getNum()));
                    // 启用单辅数量 = 启用单辅数量 + 启用单辅数量
                    vo.setAssistNum(ComputeUtil.safeAdd(vo.getAssistNum(), detail.getAssistNum()));
                }
            }
        }
        for(RmatFlowEntity detail: stopList){// 停用单
            for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i + "|" + detail.getTransScale();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                if (i == 0){// 已停用
                    vo.setStopedNum(ComputeUtil.safeAdd(vo.getStopedNum(), detail.getNum()));
                    // 停用单辅数量 = 停用单辅数量 + 停用单辅数量
                    vo.setAssistNum(ComputeUtil.safeAdd(vo.getAssistNum(), detail.getAssistNum()));
                } else {
                    // 已启用 = 已启用 - 已停用
                    vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getNum()));
                    // 启用单辅数量 = 启用单辅数量 - 停用单辅数量
                    vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
                }
            }
        }
        for(RmatFlowEntity detail: restList){//退赔单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            if(outRestDetailMap.containsKey(detail.getSourceDetailId())){
                OutRmatRestituteDetailEntity outDetail = outRestDetailMap.get(detail.getSourceDetailId());
                //流水表里面的退赔没有报废数量
                vo.setRestitutedNum(ComputeUtil.safeAdd(vo.getRestitutedNum(), ComputeUtil.safeDiv(outDetail.getScrapNum(),detail.getTransScale())));
                vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), outDetail.getScrapNum()));
            }
            vo.setRestitutedNum(ComputeUtil.safeAdd(vo.getRestitutedNum(), detail.getNum()));
            // 辅数量 = 辅数量 - 退赔单辅数量
            vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
        }
        for(RmatFlowEntity detail : loseList){// 遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setLosedNum(ComputeUtil.safeAdd(vo.getLosedNum(), detail.getNum()));
            // 辅数量 = 辅数量 - 遗失单辅数量
            vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
        }
        for(RmatFlowEntity detail : tempRestList){// 未生效退赔单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            if(outRestDetailMap.containsKey(detail.getSourceDetailId())){
                OutRmatRestituteDetailEntity outDetail = outRestDetailMap.get(detail.getSourceDetailId());
                //流水表里面的退赔没有报废数量
                vo.setTempRestNum(ComputeUtil.safeAdd(vo.getTempRestNum(), ComputeUtil.safeDiv(outDetail.getScrapNum(),detail.getTransScale())));
                if("lose".equals(type)){
                    vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), outDetail.getScrapNum()));
                }
            }
            vo.setTempRestNum(ComputeUtil.safeAdd(vo.getTempRestNum(), detail.getNum()));
            if("lose".equals(type)){
                // 辅数量 = 辅数量 - 未生效退赔单辅数量
                vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
            }
        }
        for(RmatFlowEntity detail : tempLoseList){// 未生效遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setTempLoseNum(ComputeUtil.safeAdd(vo.getTempLoseNum(), detail.getNum()));
            if("rest".equals(type)){
                // 辅数量 = 辅数量 - 未生效遗失单辅数量
                vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
            }
        }
        for(Iterator<MaterialVO> it = map.values().iterator(); it.hasNext();){
            MaterialVO vo = it.next();
            switch(type){
                case "start":// 在场可启用数量 = 已停用 - 已退赔 - 已遗失
                    if("1".equals(vo.getUseStatus())){
                        it.remove();
                        continue;
                    }
                    vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    break;
                case "stop":// 在场可停用数量 = 已启用 - 已退赔 - 已遗失
                    if("0".equals(vo.getUseStatus())){
                        it.remove();
                        continue;
                    }
                    vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    break;
                case "rest":
                    if("0".equals(vo.getUseStatus())){// 可退赔数量 = 已停用 - 已退赔 - 已遗失 - 未生效遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 可退赔数量 = 已启用 - 已退赔 - 已遗失 - 未生效遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
                    }
                    break;
                case "lose":
                    if("0".equals(vo.getUseStatus())){// 可遗失数量 = 已停用 - 已退赔 - 已遗失 - 未生效退赔
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempRestNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 可遗失数量 = 已启用 - 已退赔 - 已遗失 - 未生效退赔
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempRestNum()));
                    }
                    break;
                case "report":
                    if("0".equals(vo.getUseStatus())){// 在场停用数量 = 已停用 - 已退赔 - 已遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 在场启用数量 = 已停用 - 已退赔 - 已遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    }
                    break;
                case "restNoUse":// 退赔在场材料不需要区分启用停用，进行汇总
                    if("0".equals(vo.getUseStatus())){// 可退赔数量 = 已停用 - 已退赔 - 已遗失 - 未生效遗失
                        BigDecimal refNum = ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum());
                        key = vo.getContractId() + "|" + vo.getMaterialId() + "|" + vo.getRentCalculationType() + "|" + 1 + "|" + vo.getTransScale();
                        if(map.containsKey(key)){
                            MaterialVO data = map.get(key);
                            data.setRefNum(ComputeUtil.safeAdd(data.getRefNum(), refNum));
                        }
                        it.remove();
                        continue;
                    }
                    if("1".equals(vo.getUseStatus())){// 可退赔数量 = 已启用 - 已退赔 - 已遗失 - 未生效遗失
                        BigDecimal refNum = ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum());
                        vo.setRefNum(ComputeUtil.safeAdd(vo.getRefNum(), refNum));
                        vo.setUseStatus(null);
                    }
                    break;
                default:
                    break;
            }
            vo.setNumM(vo.getRefNum());// 可参照主数量记录
            // 在场材料档案的可参照数量使用辅数量，台账的在场数量使用主数量
            if(!"report".equals(type)){
                vo.setRefNum(vo.getAssistNum());
            }
            // 过滤数量小于0
            if(vo.getRefNum() == null || vo.getRefNum().compareTo(BigDecimal.ZERO) <= 0){
                it.remove();
                continue;
            }
        }
        return new ArrayList<>(map.values());
    }

    @Override
    public List<MaterialVO> queryCalculateList(Long contractId, Date startDate, Date endDate) {
        QueryParam param = new QueryParam();// 深拷贝
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        param.getOrderMap().put("createTime", QueryParam.ASC);
        Parameter parameter = new Parameter(QueryParam.LE, DateUtil.formatSeconds(endDate));
        param.getParams().put("billDate", parameter);
        List<RmatFlowEntity> rmatFlowList = flowService.queryList(param, false);

        List<RmatFlowEntity> checkList = new ArrayList<>();// 验收单
        List<RmatFlowEntity> startList = new ArrayList<>();// 启用单
        List<RmatFlowEntity> stopList = new ArrayList<>();// 停用单
        List<RmatFlowEntity> restList = new ArrayList<>();// 退赔单
        List<RmatFlowEntity> loseList = new ArrayList<>();// 遗失单
        for(RmatFlowEntity flow : rmatFlowList){
            if(RmatCommonConsts.YES.equals(flow.getEffectiveState())){
                if(BillTypeEnum.租出出库单.getCode().equals(flow.getBillTypeCode())){
                    checkList.add(flow);
                }
                if(BillTypeEnum.辅料中心租出停用单.getCode().equals(flow.getBillTypeCode())){
                    stopList.add(flow);
                }
                if(BillTypeEnum.辅料中心租出启用单.getCode().equals(flow.getBillTypeCode())){
                    startList.add(flow);
                }
                if(BillTypeEnum.租出退赔单.getCode().equals(flow.getBillTypeCode())){
                    restList.add(flow);
                }
                if(BillTypeEnum.租出遗失单.getCode().equals(flow.getBillTypeCode())){
                    loseList.add(flow);
                }
            }
        }
// 租出退赔单完好/维修/报废数量
        List<Long> restIds = restList.stream().map(RmatFlowEntity::getSourceDetailId).collect(Collectors.toList());
        List<OutRmatRestituteDetailEntity> outRestDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(restIds)){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, restIds));
            outRestDetailList = outRestDetailService.queryList(queryParam);
        }
        Map<Long, OutRmatRestituteDetailEntity> outRestDetailMap = outRestDetailList.stream().collect(
                Collectors.toMap(OutRmatRestituteDetailEntity::getId, Function.identity(),(t1, t2)->t2));
        if(MapUtils.isEmpty(outRestDetailMap)){
            outRestDetailMap = new HashMap<>();
        }
        Map<String, MaterialVO> map = new HashMap<>();// key-合同主键+物料主键+计组方式+转换系数，value-物料
        String key = null;// 0-停用，1-启用
        Map<Date, List<Date>> dateMap = new HashMap<>();
        Map<Date, List<Date>> cdateMap = new HashMap<>();
        for(RmatFlowEntity detail : checkList){// 验收单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            MaterialVO vo = new MaterialVO();
            if(!map.containsKey(key)){
                vo.setId(key);
                // 转换材料明细信息
                this.transferVO(detail, vo);
            } else {
                vo = map.get(key);
            }
            vo.setUseStatus(CommonConstant.YES);
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                // 已进场
                vo.setCheckedNum(ComputeUtil.safeAdd(vo.getCheckedNum(), detail.getAssistNum()));
                // 已启用 = 已进场
                vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getAssistNum()));
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.启用, date, detail.getId(), detail.getAssistNum());
            }
            map.put(key, vo);
        }
        for(RmatFlowEntity detail : startList){// 启用单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            MaterialVO vo = new MaterialVO();
            if(!map.containsKey(key)){
                vo.setId(key);
                // 转换材料明细信息
                this.transferVO(detail, vo);
            } else {
                vo = map.get(key);
            }
            vo.setUseStatus(CommonConstant.YES);
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                // 已停用
                vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getAssistNum()));
                // 已启用
                vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getAssistNum()));
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.启用, date, detail.getId(), detail.getAssistNum());
            }
            map.put(key, vo);
        }
        for(RmatFlowEntity detail : stopList){// 停用单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            MaterialVO vo = new MaterialVO();
            if(!map.containsKey(key)){
                vo.setId(key);
                // 转换材料明细信息
                this.transferVO(detail, vo);
            } else {
                vo = map.get(key);
            }
            vo.setUseStatus(CommonConstant.NO);
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                // 已停用
                vo.setStopedNum(ComputeUtil.safeAdd(vo.getStopedNum(), detail.getAssistNum()));
                // 已启用
                vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getAssistNum()));
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.停用, date, detail.getId(), detail.getAssistNum());
            }
            map.put(key, vo);
        }
        for(RmatFlowEntity detail : restList){// 退赔单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setUseStatus(detail.getUseStatus());
            if(outRestDetailMap.containsKey(detail.getSourceDetailId())){
                OutRmatRestituteDetailEntity outDetail = outRestDetailMap.get(detail.getSourceDetailId());
                //流水表里面的退赔没有报废数量
                vo.setRestitutedNum(ComputeUtil.safeAdd(vo.getRestitutedNum(), ComputeUtil.safeDiv(outDetail.getScrapNum(),detail.getTransScale())));
//                vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), outDetail.getScrapNum()));
                detail.setAssistNum(ComputeUtil.safeAdd(detail.getAssistNum(),outDetail.getScrapNum()));
            }
//            BigDecimal restNum = ComputeUtil.safeAdd(detail.getFullNum(), detail.getMaintainNum(), detail.getScrapNum());
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                vo.setRestitutedNum(ComputeUtil.safeAdd(vo.getRestitutedNum(), detail.getAssistNum()));
                if(CommonConstant.NO.equals(vo.getUseStatus())) {// 已停用
                    vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getAssistNum()));
                }
                if(CommonConstant.YES.equals(vo.getUseStatus())) {// 已启用
                    vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getAssistNum()));
                }
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.退场, date, detail.getId(), detail.getAssistNum());
            }
        }
        for(RmatFlowEntity detail : loseList){// 遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setUseStatus(detail.getUseStatus());
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                vo.setLosedNum(ComputeUtil.safeAdd(vo.getLosedNum(), detail.getAssistNum()));
                if(CommonConstant.NO.equals(vo.getUseStatus())) {// 已停用
                    vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getAssistNum()));
                }
                if(CommonConstant.YES.equals(vo.getUseStatus())) {// 已启用
                    vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getAssistNum()));
                }
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.退场, date, detail.getId(), detail.getAssistNum());
            }
        }
        for(String keys : map.keySet()){
            MaterialVO vo = map.get(keys);
            if(CommonConstant.NO.equals(vo.getUseStatus())){// 在场停用数量
                vo.setRefNum(vo.getStopedNum());
            }
            if(CommonConstant.YES.equals(vo.getUseStatus())){// 在场启用数量
                vo.setRefNum(vo.getStartedNum());
            }
            if(ComputeUtil.isGreaterThan(vo.getStopedNum(), BigDecimal.ZERO)){// 停用存在期初数量
                // 生成期初
                vo.setUseStatus(CommonConstant.NO);
                this.addBeginVO(vo, MaterialStateEnum.停用, startDate, IdWorker.getId(), vo.getStopedNum());
            }
            if(ComputeUtil.isGreaterThan(vo.getStartedNum(), BigDecimal.ZERO)){// 启用存在期初数量
                // 生成期初
                vo.setUseStatus(CommonConstant.YES);
                this.addBeginVO(vo, MaterialStateEnum.启用, startDate, IdWorker.getId(), vo.getStartedNum());
            }
            List<MaterialFlowVO> flowList = vo.getFlowList();
            if(CollectionUtils.isNotEmpty(flowList)){
                flowList.sort(Comparator.comparing(MaterialFlowVO::getOperationDate));
            }
            vo.setFlowList(flowList);
        }
        return new ArrayList<>(map.values());
    }

    /**
     * 获取最大操作时间
     * @param dateMap
     * @param cdateMap
     * @param billDate
     * @param createTime
     * @return
     */
    private Date getMaxDate(Map<Date, List<Date>> dateMap, Map<Date, List<Date>> cdateMap, Date billDate, Date createTime) {
        Date date = DateUtil.concatDate(billDate, createTime);
        List<Date> list = new ArrayList<>();
        List<Date> clist = new ArrayList<>();
        Date day = DateUtil.parseDate(DateUtil.formatSeconds(date).substring(0,10));
        if(dateMap.containsKey(day)){
            list = dateMap.get(day);
            Date maxDate = list.stream().max(Comparator.comparing(x->x)).orElse(null);
            clist = cdateMap.get(day);
            Date cmaxDate = clist.stream().max(Comparator.comparing(x->x)).orElse(null);
            if(DateUtil.compareDate(date, maxDate) < 0 && DateUtil.compareDate(createTime, cmaxDate) > 0){
                date = DateUtil.addSeconds(maxDate, 1);
                if(DateUtil.compareDate(date, DateUtil.endOfDate(date)) > 0){
                    date = DateUtil.endOfDate(date);
                }
            }
        }
        list.add(date);
        dateMap.put(day, list);
        clist.add(createTime);
        cdateMap.put(day, clist);
        return date;
    }

    /**
     * 生成流水
     * @param vo
     * @param stateEnum
     * @param date
     * @param id
     * @param num
     */
    private void addFlowVO(MaterialVO vo, MaterialStateEnum stateEnum, Date date, Long id, BigDecimal num) {
        MaterialFlowVO flowVO = new MaterialFlowVO();
        flowVO.setParameterId(vo.getId());
        flowVO.setMaterialState(stateEnum.getCode());
        flowVO.setOperationDate(date);
        flowVO.setSourceId(id);
        flowVO.setSourceType(stateEnum.getDescription());
        flowVO.setNum(num);
        flowVO.setUseStatus(vo.getUseStatus());
        flowVO.setStopedNum(vo.getStopedNum());
        flowVO.setStartedNum(vo.getStartedNum());
        flowVO.setId(id);
        List<MaterialFlowVO> flowList = vo.getFlowList() != null ? vo.getFlowList() : new ArrayList<>();
        flowList.add(flowVO);
        vo.setFlowList(flowList);
    }

    /**
     * 生成期初
     * @param vo
     * @param stateEnum
     * @param date
     * @param id
     * @param num
     */
    private void addBeginVO(MaterialVO vo, MaterialStateEnum stateEnum, Date date, Long id, BigDecimal num) {
        MaterialFlowVO flowVO = new MaterialFlowVO();
        flowVO.setParameterId(vo.getId());
        flowVO.setMaterialState(stateEnum.getCode());
        flowVO.setOperationDate(date);
        flowVO.setSourceId(id);
        flowVO.setSourceType(stateEnum.getDescription());
        flowVO.setNum(num);
        flowVO.setUseStatus(vo.getUseStatus());
        flowVO.setId(id);
        flowVO.setStopedNum(vo.getStopedNum());
        flowVO.setStartedNum(vo.getStartedNum());
        List<MaterialFlowVO> beginList = vo.getBeginList() != null ? vo.getBeginList() : new ArrayList<>();
        beginList.add(flowVO);
        vo.setBeginList(beginList);
    }

    /**
     * 转换材料明细信息
     * @param detail
     * @param vo
     */
    private void transferVO(RmatFlowEntity detail, MaterialVO vo) {
        vo.setContractId(detail.getContractId());
        vo.setContractCode(detail.getContractCode());
        vo.setContractName(detail.getContractName());
        vo.setStoreId(detail.getStoreId());
        vo.setStoreName(detail.getStoreName());
        vo.setSourceType(detail.getSourceType());
        vo.setOrgId(detail.getOrgId());
        vo.setOrgCode(detail.getOrgCode());
        vo.setOrgName(detail.getOrgName());
        vo.setParentOrgId(detail.getParentOrgId());
        vo.setParentOrgCode(detail.getParentOrgCode());
        vo.setParentOrgName(detail.getParentOrgName());
        vo.setSupplierId(detail.getSupplierId());
        vo.setSupplierName(detail.getSupplierName());

        vo.setMaterialTypeId(detail.getMaterialTypeId());
        vo.setMaterialTypeName(detail.getMaterialTypeName());
        vo.setMaterialId(detail.getMaterialId());
        vo.setMaterialCode(detail.getMaterialCode());
        vo.setMaterialName(detail.getMaterialName());
        vo.setSpec(detail.getSpec());
        vo.setUnitId(detail.getUnitId());
        vo.setUnitName(detail.getUnitName());
        vo.setAssistUnitId(detail.getAssistUnitId());
        vo.setAssistUnitName(detail.getAssistUnitName());
        vo.setTransScale(detail.getTransScale());
        vo.setRentCalculationType(detail.getRentCalculationType());
        vo.setRentTypeName("2".equals(detail.getRentCalculationType()) ? "工程量租" :
                "1".equals(detail.getRentCalculationType()) ? "月租" :
                "0".equals(detail.getRentCalculationType()) ? "日租" : null);

        vo.setContractRmatMethod(detail.getContractRmatMethod());
    }

    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));

        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        QueryParam param = Utils.deepCopy(queryParam);// 深拷贝
        if(billId != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        Future<JSONArray> future1 = ListCallable.excute(threadPool, BillTypeEnum.租出出库单.getName().equals(billType) ? param : queryParam, outRmatDeliveryService);// 发货单
        Future<JSONArray> future2 = ListCallable.excute(threadPool, BillTypeEnum.辅料中心租出启用单.getName().equals(billType) ? param : queryParam, outRmatStartService);// 启用单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, BillTypeEnum.辅料中心租出停用单.getName().equals(billType) ? param : queryParam, outRmatStopService);// 停用单
        Future<JSONArray> future4 = ListCallable.excute(threadPool, BillTypeEnum.租出退赔单.getName().equals(billType) ? param : queryParam, outRmatRestituteService);// 退赔单
        Future<JSONArray> future5 = ListCallable.excute(threadPool, BillTypeEnum.租出遗失单.getName().equals(billType) ? param : queryParam, outRmatLoseService);// 遗失单
        Future<JSONArray> future6 = ListCallable.excute(threadPool, BillTypeEnum.租出租金计算单.getName().equals(billType) ? param : queryParam, rentService);// 租金计算单

        List<OutRmatDeliveryEntity> checkList = new ArrayList<>();// 发货单
        List<OutRmatStartEntity> startList = new ArrayList<>();// 启用单
        List<OutRmatStopEntity> stopList = new ArrayList<>();// 停用单
        List<OutRmatRestituteEntity> restList = new ArrayList<>();// 退赔单
        List<OutRmatLoseEntity> loseList = new ArrayList<>();// 遗失单
        List<OutRmatCalculateEntity> rentList = new ArrayList<>();// 租金计算单
        try {
            checkList = JSONObject.parseArray(future1.get().toJSONString(), OutRmatDeliveryEntity.class);
            startList = JSONObject.parseArray(future2.get().toJSONString(), OutRmatStartEntity.class);
            stopList = JSONObject.parseArray(future3.get().toJSONString(), OutRmatStopEntity.class);
            restList = JSONObject.parseArray(future4.get().toJSONString(), OutRmatRestituteEntity.class);
            loseList = JSONObject.parseArray(future5.get().toJSONString(), OutRmatLoseEntity.class);
            rentList = JSONObject.parseArray(future6.get().toJSONString(), OutRmatCalculateEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        if(CollectionUtils.isNotEmpty(checkList) && BillTypeEnum.租出出库单.getName().equals(billType)){
            throw new BusinessException("当前合同存在非审批通过态的出库单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(startList) && BillTypeEnum.辅料中心租出启用单.getName().equals(billType)){
            throw new BusinessException("当前合同存在非审批通过态的启用单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(stopList) && BillTypeEnum.辅料中心租出停用单.getName().equals(billType)){
            throw new BusinessException("当前合同存在非审批通过态的停用单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(restList) && BillTypeEnum.租出退赔单.getName().equals(billType)){
            throw new BusinessException("当前合同存在非审批通过态的退赔单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(loseList)&& BillTypeEnum.租出遗失单.getName().equals(billType)){
            throw new BusinessException("当前合同存在非审批通过态的遗失单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(rentList) && BillTypeEnum.租出租金计算单.getName().equals(billType)){
            throw new BusinessException("当前合同存在非审批通过态的租金计算单，不允许" + type + "!");
        }
        return "校验通过！";
    }

    @Override
    public Date getLastDate(Map<String, Object> params) {
        return baseMapper.getLastDate(params);
    }

    @Override
    public Map<Date, Date> getMaxTime(Map<String, Object> params) {
        List<MaxTimeVO> list = baseMapper.getMaxTime(params);
        list.removeAll(Collections.singleton(null));
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        return list.stream().filter(x->x.getTime() != null).collect(Collectors.toMap(MaxTimeVO::getDate, MaxTimeVO::getTime));
    }

    @Override
    public List<MaterialVO> proMaterialList(QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        String type = "report";// start-在场可启用，stop-在场可停用，rest-在场可退赔，lose-在场可遗失，report-验收台账

        // 使用状态(启用、停用)
        Parameter useStatusParameter = param.getParams().get("useStatus");
        List<String> useStatusList = new ArrayList<>();
        if(useStatusParameter != null && useStatusParameter.getValue() != null){
            String useStatus = (String)useStatusParameter.getValue();
            String[] split = useStatus.split(",");
            useStatusList = Arrays.asList(split);
            param.getParams().remove("useStatus");
        }
        // 租赁方式(内租、外租)
        Parameter contractRmatMethodParameter = param.getParams().get("contractRmatMethod");
        List<String> contractRmatMethodList = new ArrayList<>();
        if(contractRmatMethodParameter != null && contractRmatMethodParameter.getValue() != null){
            String contractRmatMethod = (String)contractRmatMethodParameter.getValue();
            String[] split = contractRmatMethod.split(",");
            contractRmatMethodList = Arrays.asList(split);
            param.getParams().remove("contractRmatMethod");
        }
        // 计租方式(日租、月租、工程量租)
        Parameter rentCalculationTypeParameter = param.getParams().get("rentCalculationType");
        List<String> rentCalculationTypeList = new ArrayList<>();
        if(rentCalculationTypeParameter != null && rentCalculationTypeParameter.getValue() != null){
            String rentCalculationType = (String)rentCalculationTypeParameter.getValue();
            String[] split = rentCalculationType.split(",");
            rentCalculationTypeList = Arrays.asList(split);
            param.getParams().remove("rentCalculationType");
        }
        List<MaterialVO> list = this.queryCheckList(param, type);

        List<MaterialVO> resList = new ArrayList<>();
        for(MaterialVO vo : list){
            boolean flag = false;
            if(useStatusList.size()>0 && !useStatusList.contains(vo.getUseStatus())){
                flag = true;
            }
            if(contractRmatMethodList.size()>0 && !contractRmatMethodList.contains(vo.getContractRmatMethod())){
                flag = true;
            }
            if(rentCalculationTypeList.size()>0 && !rentCalculationTypeList.contains(vo.getRentCalculationType())){
                flag = true;
            }
            if(!flag){
                resList.add(vo);
            }
        }
        resList.forEach(vo -> {
            if (null != vo.getContractRmatMethod()) {
                if ("0".equals(vo.getContractRmatMethod())) {
                    vo.setContractRmatMethodName("外租");
                } else if ("1".equals(vo.getContractRmatMethod())) {
                    vo.setContractRmatMethodName("内租");
                }
            } else {
                vo.setContractRmatMethodName("");
            }
            if (null != vo.getUseStatus()) {
                if ("0".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("停用");
                } else if ("1".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("启用");
                }
            } else {
                vo.setUseStatusName("");
            }
        });
        return resList;
    }

    @Override
    public String validateCheckDetail(CheckVO vo) {
        List<CheckDetailVO> detailList = vo.getCheckDetailList();

        if (CollectionUtils.isNotEmpty(detailList)){
            Boolean checkNumsSum = true;
            Boolean transScale = true;
            Boolean transScaleSecond = true;
            Boolean passMuster = true;
            for (CheckDetailVO detailVO : detailList){
                if (null == detailVO.getCheckNumsSum()){
                    checkNumsSum = false;
                }
                if (null == detailVO.getTransScale()){
                    transScale = false;
                }
                if (CommonConstant.YES_STR.equals(vo.getLoadometerWeight())){
                    if (null == detailVO.getTransScaleSecond()){
                        transScaleSecond = false;
                    }
                    if (CommonConstant.NO_STR.equals(detailVO.getPassMuster())){
                        passMuster = false;
                    }
                }
                if (!checkNumsSum){
                    throw new BusinessException("【"+detailVO.getMaterialName()+"】验收数量不能为空！");
                }
                if (!transScale){
                    throw new BusinessException("【"+detailVO.getMaterialName()+"】转换系数未设置，无法计算计量数量！");
                }
                if (!transScaleSecond){
                    throw new BusinessException("【"+detailVO.getMaterialName()+"】转换系数未设置，无法计算理论重量！");
                }
                if (!passMuster){
                    throw new BusinessException("【"+detailVO.getMaterialName()+"】净值与理论重量不符合要求！");
                }

            }
        }


        return "校验通过！";
    }



}
