package com.ejianc.business.outrmat.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.bean.ConvertEntity;
import com.ejianc.business.assist.rmat.bean.OrderDetailEntity;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.service.IConvertService;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.service.IOrderDetailService;
import com.ejianc.business.assist.rmat.vo.*;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDetailEntity;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDetailService;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 租赁订单明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRmatOrderDetail")
public class OutRmatOrderDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IConvertService convertService;//转换系数
    @Autowired
    private IOutRmatContractService outRmatContractService;//转换系数

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IOutRmatOrderDetailService service;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRmatOrderDetailVO> saveOrUpdate(@RequestBody OutRmatOrderDetailVO saveOrUpdateVO) {
    	OutRmatOrderDetailEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatOrderDetailEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                //entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	OutRmatOrderDetailVO vo = BeanMapper.map(entity, OutRmatOrderDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRmatOrderDetailVO> queryDetail(Long id) {
    	OutRmatOrderDetailEntity entity = service.selectById(id);
    	OutRmatOrderDetailVO vo = BeanMapper.map(entity, OutRmatOrderDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatOrderDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutRmatOrderDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutRmatOrderDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutRmatOrderDetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OutRmatOrderDetailEntity> page = service.queryPage(param,false);
        IPage<OutRmatOrderDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRmatOrderDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OutRmatOrderDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OutRmatOrderDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOutRmatOrderDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRmatOrderDetailVO>> refOutRmatOrderDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        Long contractId = null;
        Long orgId = null;
        Long storeId = null;
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<PlanDetailVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        OutRmatContractEntity outRmatContractEntity = new OutRmatContractEntity();
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                contractId = Long.valueOf(conditionMap.get("contractId").toString());
            }else {
                return CommonResponse.error("当前传入合同id为空！");
            }
            if (null != conditionMap.get("storeId")) {
                storeId = Long.valueOf(conditionMap.get("storeId").toString());
            }
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }else {
            return CommonResponse.success("查询参照数据成功！",new Page<>(page.getCurrent(), page.getSize(), page.getTotal()));
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<OutRmatOrderDetailVO> list = service.geOutRmatOrderDetail(wrapper, contractId);
        ConvertRequest convertRequest = new ConvertRequest();//正向
        ConvertRequest convertRequest2 = new ConvertRequest();//反向
        convertRequest.setOrgId(orgId);
        convertRequest2.setOrgId(orgId);
        List<ConvertIdVO> detailCon = new ArrayList<>();//正向
        List<ConvertIdVO> detailCon2 = new ArrayList<>();//反向
        for (OutRmatOrderDetailVO outRmatOrderDetailVO : list) {
            ConvertIdVO detailIdVO = new ConvertIdVO();//正向
            detailIdVO.setMaterialId(outRmatOrderDetailVO.getMaterialId());
            detailIdVO.setUnitId(outRmatOrderDetailVO.getUnitId());
            detailIdVO.setUnitMId(outRmatOrderDetailVO.getUnitMId());
            detailCon.add(detailIdVO);
            ConvertIdVO detailIdVO2 = new ConvertIdVO();//反向
            detailIdVO2.setMaterialId(outRmatOrderDetailVO.getMaterialId());
            detailIdVO2.setUnitId(outRmatOrderDetailVO.getUnitMId());
            detailIdVO2.setUnitMId(outRmatOrderDetailVO.getUnitId());
            detailCon2.add(detailIdVO2);
        }
        convertRequest.setConvertIds(detailCon);
        convertRequest2.setConvertIds(detailCon2);
        Map<String, ConvertEntity> residualRate = convertService.getResidualRate(convertRequest);//正向
        Map<String, ConvertEntity> residualRate2 = convertService.getResidualRate(convertRequest2);//反向
        for (OutRmatOrderDetailVO outRmatOrderDetailVO : list) {
            String key = outRmatOrderDetailVO.getMaterialId() + "," + outRmatOrderDetailVO.getUnitMId() + "," + outRmatOrderDetailVO.getUnitId();
            ConvertEntity convertEntity = residualRate.get(key);//正向
            String key2 = outRmatOrderDetailVO.getMaterialId() + "," + outRmatOrderDetailVO.getUnitId() + "," + outRmatOrderDetailVO.getUnitMId();
            ConvertEntity convertEntity2 = residualRate2.get(key2);//反向
            if(null!=convertEntity){
                outRmatOrderDetailVO.setTransScale(convertEntity.getTransScale());
                outRmatOrderDetailVO.setDeviationRate(convertEntity.getDeviationRate());
            }else if (null!=convertEntity2){
                outRmatOrderDetailVO.setTransScale(convertEntity2.getTransScale());
                outRmatOrderDetailVO.setDeviationRate(convertEntity2.getDeviationRate());
            }
            if(String.valueOf(outRmatOrderDetailVO.getUnitId()).equals(String.valueOf(outRmatOrderDetailVO.getUnitMId()))){
                outRmatOrderDetailVO.setTransScale(new BigDecimal("1"));
            }
        }

        // 给库存可用量赋值
        this.getStoreNum(storeId, orgId, list);

        IPage<OutRmatOrderDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 给库存可用量赋值
     * @param storeId
     * @param orgId
     * @param list
     */
    private void getStoreNum( Long storeId, Long orgId, List<OutRmatOrderDetailVO> list) {
        List<StoreNumVO> vos = new ArrayList<>();
        for(OutRmatOrderDetailVO detail : list){
            StoreNumVO vo = new StoreNumVO();
            vo.setOrgId(orgId);
            vo.setMaterialId(detail.getMaterialId());
            vo.setUnitMId(detail.getUnitMId());
            vo.setUnitId(detail.getUnitId());
            vo.setStoreId(orgId);
            vo.setSourceType(RmatCommonConsts.RENT_OUT);
            if(storeId != null){
                vo.setStoreId(storeId);
                vo.setSourceType(RmatCommonConsts.PURCHASE_OUT);
            }
            vos.add(vo);
        }
        vos = materialService.getStoreNum(vos);
        Map<String, StoreNumVO> storeMap = vos.stream().collect(Collectors.toMap(x->x.getStoreId() + "|" + x.getMaterialId(), x->x));
        for(OutRmatOrderDetailVO detail : list){
            String key = storeId != null ? storeId + "|" + detail.getMaterialId() : orgId + "|" + detail.getMaterialId();
            if(storeMap.containsKey(key)){
                detail.setStoreNumsSum(storeMap.get(key).getAssistNum());
                detail.setStoreNumM(storeMap.get(key).getStoreNum());
            }
        }
    }
}
