package com.ejianc.business.assist.report.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.assist.report.bean.MonthReportDetailEntity;
/**
 * 自有周转材月报表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assistrmat_month_report")
public class MonthReportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="period")
    private String period; // 期间
    @TableField(value="push_date")
    private Date pushDate; // 生成日期
    @TableField(value="material_type_id")
    private Long materialTypeId; // 周转材大类主键
    @TableField(value="material_type_name")
    private String materialTypeName; // 周转材大类名称
    @TableField(value="qc_flag")
    private Integer qcFlag; // 是否期初数据：0-是，1-否
    @TableField(value="last_storage_num")
    private BigDecimal lastStorageNum; // 上月账存
    @TableField(value="last_scrap_nums")
    private BigDecimal lastScrapNums; // 上月累计报废
    @TableField(value="month_scrap_num")
    private BigDecimal monthScrapNum; // 本月报废
    @TableField(value="scrap_nums")
    private BigDecimal scrapNums; // 累计报废
    @TableField(value="month_stock_num")
    private BigDecimal monthStockNum; // 本月库存
    @TableField(value="month_balance_num")
    private BigDecimal monthBalanceNum; // 本月结存
    @TableField(value="month_storage_num")
    private BigDecimal monthStorageNum; // 本月账存
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="monthReportDetailService",pidName = "reportId")
    private List<MonthReportDetailEntity> monthReportDetailList = new ArrayList<>(); // 自有周转材月报表子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getPeriod() {
        return period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }
    public Date getPushDate() {
        return pushDate;
    }

    public void setPushDate(Date pushDate) {
        this.pushDate = pushDate;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Integer getQcFlag() {
        return qcFlag;
    }

    public void setQcFlag(Integer qcFlag) {
        this.qcFlag = qcFlag;
    }
    public BigDecimal getLastStorageNum() {
        return lastStorageNum;
    }

    public void setLastStorageNum(BigDecimal lastStorageNum) {
        this.lastStorageNum = lastStorageNum;
    }
    public BigDecimal getLastScrapNums() {
        return lastScrapNums;
    }

    public void setLastScrapNums(BigDecimal lastScrapNums) {
        this.lastScrapNums = lastScrapNums;
    }
    public BigDecimal getMonthScrapNum() {
        return monthScrapNum;
    }

    public void setMonthScrapNum(BigDecimal monthScrapNum) {
        this.monthScrapNum = monthScrapNum;
    }
    public BigDecimal getScrapNums() {
        return scrapNums;
    }

    public void setScrapNums(BigDecimal scrapNums) {
        this.scrapNums = scrapNums;
    }
    public BigDecimal getMonthStockNum() {
        return monthStockNum;
    }

    public void setMonthStockNum(BigDecimal monthStockNum) {
        this.monthStockNum = monthStockNum;
    }
    public BigDecimal getMonthBalanceNum() {
        return monthBalanceNum;
    }

    public void setMonthBalanceNum(BigDecimal monthBalanceNum) {
        this.monthBalanceNum = monthBalanceNum;
    }
    public BigDecimal getMonthStorageNum() {
        return monthStorageNum;
    }

    public void setMonthStorageNum(BigDecimal monthStorageNum) {
        this.monthStorageNum = monthStorageNum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<MonthReportDetailEntity> getMonthReportDetailList() {
        return monthReportDetailList;
    }

    public void setMonthReportDetailList(List<MonthReportDetailEntity> monthReportDetailList) {
        this.monthReportDetailList = monthReportDetailList;
    }
}
