package com.ejianc.business.assist.rmat.controller.api;

import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.pro.pricelib.vo.PriceContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/api/assistRmatIn/")
public class AssistRmatInContractApi {

    @Autowired
    private IContractService service;

    /**
     * 查询周转材价格库所需-辅料周转才-租入合同-数据
     * @param initFlag
     * @return
     */
    @GetMapping(value = "getPriceContractDataByAssistRmatIn")
    CommonResponse<List<PriceContractVO>> getPriceContractDataByAssistRmatIn(@RequestParam(value = "initFlag") String initFlag){
        List<PriceContractVO> priceContractList = service.queryPriceContractDataByAssistRmatIn(initFlag);
        return CommonResponse.success("查询周转材价格库所需-辅料周转才-租入合同-数据结束！", priceContractList);
    }
}
