package com.ejianc.business.outrmat.contract.mapper;

import com.ejianc.business.outrmat.contract.bean.OutRmatContractDailyRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractMonthRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractNumRentEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 周转材租赁合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface OutRmatContractMapper extends BaseCrudMapper<OutRmatContractEntity> {

    @Select("select * from ejc_outrmat_contract where dr = 0 and create_time >= #{time} or update_time >= #{time}")
    List<OutRmatContractEntity> getContractListByTime(Date qDate);

    @Select({
            "<script>",
            "select * from ejc_outrmat_contract_daily_rent where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<OutRmatContractDailyRentEntity> getContractDayDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    @Select({
            "<script>",
            "select * from ejc_outrmat_contract_month_rent where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<OutRmatContractMonthRentEntity> getContractMonDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    @Select({
            "<script>",
            "select * from ejc_outrmat_contract_num_rent where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<OutRmatContractNumRentEntity> getContractNumDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);
}
