package com.ejianc.business.outrmat.start.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleEntity;
import com.ejianc.business.outrmat.start.mapper.OutRmatStartMapper;
import com.ejianc.business.outrmat.start.service.IOutRmatStartService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.outrmat.start.bean.OutRmatStartEntity;
import com.ejianc.business.outrmat.start.vo.OutRmatStartDetailVO;
import com.ejianc.business.outrmat.start.vo.OutRmatStartVO;
import com.ejianc.business.outrmat.stop.bean.OutRmatStopEntity;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 启用单实体
 *
 * @author generator
 *
 */
@Service("outRmatStartService")
public class OutRmatStartServiceImpl extends BaseServiceImpl<OutRmatStartMapper, OutRmatStartEntity> implements IOutRmatStartService{

    private static final String BILL_CODE = "OUTRMAT_START";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOutRmatMaterialService materialService;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IReceiptsApi receiptsApi;

    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.辅料中心租出启用单.getCode();
    private static final String BILL_NAME = BillTypeEnum.启用单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/start/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/start/billDel";


    @Override
    public OutRmatStartVO saveOrUpdate(OutRmatStartVO saveOrUpdateVO) {
        // 同一个合同只能存在一个自由态或审批中的单据
        this.validateContract(saveOrUpdateVO.getContractId(), saveOrUpdateVO.getId());
        // 同一个合同只能存在一个自由态或审批中的单据
        materialService.validateContract(saveOrUpdateVO.getContractId(), BillTypeEnum.辅料中心租出启用单.getName(), saveOrUpdateVO.getId(), OutRmatConstant.保存);
        // 校验必须大于最大单据日期
        this.validateTime(saveOrUpdateVO, MaterialConstant.保存);
        // 校验数量不能大于可参照数量
        this.validateNum(saveOrUpdateVO);
        OutRmatStartEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatStartEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 汇总材料分类
        List<OutRmatStartDetailVO> detailList = saveOrUpdateVO.getDetailList();
        String materialTypeNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(x->x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);

        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, OutRmatStartVO.class);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<OutRmatStartEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的启用单，不允许新增!");
        }
        return "校验通过！";
    }

    /**
     * 校验必须大于最大单据日期
     * @param outRmatStartVO
     * @return
     */
    @Override
    public String validateTime(OutRmatStartVO outRmatStartVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", outRmatStartVO.getContractId());
        if(outRmatStartVO.getId() != null){
            params.put("billType", OutRmatConstant.启用单);
            params.put("billId", outRmatStartVO.getId());
        }
        Date lastDate = materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = materialService.getMaxTime(params);

        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(outRmatStartVO.getStartTime(), lastDate, maxTimeMap, outRmatStartVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(outRmatStartVO.getStartTime())
                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        for(OutRmatStartDetailVO vo : outRmatStartVO.getDetailList()){
            if(ValidateUtil.compareDate(vo.getStartTime(), lastDate, maxTimeMap, vo.getCreateTime())){
                throw new BusinessException(DateUtil.formatDate(vo.getStartTime())
                        + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }
        return "校验通过！";
    }

    @Override
    public boolean pushBillToSupCenter(OutRmatStartEntity entity) {
        if (entity.getRentType().equals("1")){
            //辅料中心与项目方组织转换 复制一个新对象推送，防止后面有保存/修改操作
            OutRmatStartEntity map = BeanMapper.map(entity, OutRmatStartEntity.class);
            map.setOrgId(entity.getProjectDeptId());
            map.setOrgCode(entity.getProjectDeptCode());
            map.setOrgName(entity.getProjectDeptName());
            map.setParentOrgCode(entity.getProjectOrgCode());
            map.setParentOrgId(entity.getProjectOrgId());
            map.setParentOrgName(entity.getProjectOrgName());
            logger.info("推送辅料中心数据"+JSONObject.toJSONString(map)+"----"+BILL_NAME);
            Boolean syncFlag = receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON(map),BILL_NAME).isSuccess();
            return syncFlag;
        }
        return true;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        OutRmatStartEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                OutRmatStartEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(OutRmatStartEntity entity) {
        if (entity.getRentType().equals("1")){
            logger.info("删除辅料中心数据"+entity.getId()+"----"+BILL_NAME);
            Boolean delSuc = receiptsApi.delReceipts(entity.getId(),BILL_NAME).isSuccess();
            logger.info("删除辅料中心数据"+delSuc);
            return delSuc;
        }
        return true;
    }

    /**
     * 校验数量不能大于可参照数量
     * @param outRmatStartVO
     * @return
     */
    private String validateNum(OutRmatStartVO outRmatStartVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, outRmatStartVO.getContractId()));
        List<MaterialVO> list = materialService.queryCheckList(param, "start");
        Map<String, MaterialVO> map = list.stream().collect(Collectors.toMap(x->x.getMaterialId() + "|" + x.getRentCalculationType() + "|" + x.getTransScale(), Function.identity()));
        String key = null;
        for(OutRmatStartDetailVO vo : outRmatStartVO.getDetailList()){
            key = vo.getMaterialId() + "|" + vo.getRentCalculationType() + "|" + vo.getTransScale();
            if(map.containsKey(key) && vo.getNum().compareTo(map.get(key).getRefNum()) > 0){
                throw new BusinessException("子表数量大于可参照数量");
            }
        }
        return "校验通过！";
    }

    @Override
    public String updateBillSupSignSync(Map<String,String> map) {
        String billId = map.get("billId");
        OutRmatStartEntity entity = super.selectById(Long.valueOf(billId));
        String msg = pushSupUtil.updateBillSupSignSync(map, (JSONObject) JSONObject.toJSON(entity),
                OutRmatStartEntity.class, BILL_TYPE, BILL_NAME);
        return msg;
    }
}
