package com.ejianc.business.assist.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 周转材租赁合同-工程量租明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assistrmat_contract_num_rent")
public class ContractNumRentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="source_id")
    private Long sourceId; // 来源数据Id
    @TableField(value="source_type")
    private String sourceType; // 来源类型：0-定标结果带入，1-总计划，2-材料档案，3-批次计划
    @TableField(value="change_id")
    private Long changeId; // 变更表主键
    @TableField(value="change_bid")
    private Long changeBid; // 变更子表主键
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资材料分类Id
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资材料分类名称
    @TableField(value="material_name")
    private String materialName; // 材料名称
    @TableField(value="spec")
    private String spec; // 规格/型号
    @TableField(value="count")
    private BigDecimal count; // 数量
    @TableField(value="unit_price")
    private BigDecimal unitPrice; // 单价(无税)
    @TableField(value="unit_tax_price")
    private BigDecimal unitTaxPrice; // 单价
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="lose_unit_price")
    private BigDecimal loseUnitPrice; // 遗失单价(无税)
    @TableField(value="lose_unit_tax_price")
    private BigDecimal loseUnitTaxPrice; // 遗失单价
    @TableField(value="start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 计划进场时间
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 计划出场时间
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="material_id")
    private Long materialId; // 材料id
    @TableField(value="material_code")
    private String materialCode; // 材料编码
    @TableField(value="unit_id")
    private Long unitId; // 计租单位id
    @TableField(value="unit_name")
    private String unitName; // 计租单位名称

    @TableField(exist = false)
    private String rentCalculationType; // 租赁方式：0-日租，1-月租，2-工程量租
    @TableField(value = "surplus_count")
    private BigDecimal surplusCount; // 剩余数量
    @TableField(value="unit_m_id")
    private Long unitMId; // 计量单位id
    @TableField(value="unit_m_name")
    private String unitMName; // 计量单位名称			
    @TableField(value="material_type_code")
    private String materialTypeCode; // 材料分类编码
    @TableField(value="row_type")
    private Integer rowType; // 行分类：0-分类，1-材料

    @TableField(value = "quantities")
    private BigDecimal quantities; // 工程量
    @TableField(value = "rent_tax_mny")
    private BigDecimal rentTaxMny; // 租赁金额
    @TableField(value = "rent_mny")
    private BigDecimal rentMny; // 租赁金额(无税)
    @TableField(value = "rent_tax")
    private BigDecimal rentTax; // 租赁税额
    @TableField(value="history_price_area")
    private String historyPriceArea;//历史价格区间（无税）
    @TableField(value="history_tax_price_area")
    private String historyTaxPriceArea;//历史价格区间（含税）
    @TableField(value="guide_price_area")
    private String guidePriceArea; // 公司指导价区间（无税）
    @TableField(value="guide_tax_price_area")
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
    
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    
    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getLoseUnitPrice() {
        return loseUnitPrice;
    }

    public void setLoseUnitPrice(BigDecimal loseUnitPrice) {
        this.loseUnitPrice = loseUnitPrice;
    }
    public BigDecimal getLoseUnitTaxPrice() {
        return loseUnitTaxPrice;
    }

    public void setLoseUnitTaxPrice(BigDecimal loseUnitTaxPrice) {
        this.loseUnitTaxPrice = loseUnitTaxPrice;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public BigDecimal getSurplusCount() {
        return surplusCount;
    }

    public void setSurplusCount(BigDecimal surplusCount) {
        this.surplusCount = surplusCount;
    }

    public Long getUnitMId() {
        return unitMId;
    }

    public void setUnitMId(Long unitMId) {
        this.unitMId = unitMId;
    }

    public String getUnitMName() {
        return unitMName;
    }

    public void setUnitMName(String unitMName) {
        this.unitMName = unitMName;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public Integer getRowType() {
        return rowType;
    }

    public void setRowType(Integer rowType) {
        this.rowType = rowType;
    }

    public BigDecimal getQuantities() {
        return quantities;
    }

    public void setQuantities(BigDecimal quantities) {
        this.quantities = quantities;
    }

    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }

    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }

    public BigDecimal getRentTax() {
        return rentTax;
    }

    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }
}
