package com.ejianc.business.outrmat.restitute.service;

import com.ejianc.business.assist.rmat.bean.RestituteEntity;
import com.ejianc.business.assist.rmat.vo.RestituteVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * out-退赔单
 * 
 * @author generator
 * 
 */
public interface IOutRmatRestituteService extends IBaseService<OutRmatRestituteEntity> {
    List<StoreManageVO> getStoreManageVOList(OutRmatRestituteVO vo , Boolean outEffectiveON);

    OutRmatRestituteVO saveOrUpdate(OutRmatRestituteVO saveOrUpdateVO);

    void delete(List<OutRmatRestituteVO> vos);


    String validateContract(Long contractId, Long billId);

    String validateTime(OutRmatRestituteVO saveOrUpdateVO, String type);

    /**
     * 单据推送到供方协同服务
     *
     * @param entity 待推送单据
     * @return
     */
    boolean pushBillToSupCenter(OutRmatRestituteEntity entity);

    /**
     * 同步单据供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    boolean delPushBill(OutRmatRestituteEntity entity);

    //签字
    String updateBillSupSignSync(Map<String,String> map);
}
