package com.ejianc.framework.auth.security.utils;

import org.owasp.esapi.ESAPI;

import com.ejianc.framework.auth.security.esapi.EncryptException;
import com.ejianc.framework.auth.security.esapi.ICOPESAPI;

/**
 * Created by guominga on 2015/8/25.
 */
public class TokenGenerator {

    /**
     * 生成用户登陆token
     *
     * @param uname
     * @param ts
     * @param seed
     * @return token
     * @throws EncryptException
     */
    public static String genToken(String uname, long ts, String seed) throws EncryptException {
        return ICOPESAPI.encryptor().hash(uname + ts, seed);
    }

    /**
     * 生成系统的加密seed
     *
     * @return seed
     * @throws EncryptException
     */
    public static String genSeed() throws EncryptException {
        return ICOPESAPI.encryptor().hash(new String(ESAPI.securityConfiguration().getMasterKey()), new String(ESAPI.securityConfiguration().getMasterSalt()));
    }
}
