/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.auth.shiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class StatelessLogoutFilter
extends LogoutFilter {
    private static final Logger logger = LoggerFactory.getLogger(StatelessLogoutFilter.class);

    StatelessLogoutFilter() {
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        String redirectUrl = this.getRedirectUrl(request, response, subject);
        try {
            subject.logout();
            this.doLogout((HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (SessionException ise) {
            logger.debug("Encountered session exception during logout.  This can generally safely be ignored.", (Throwable)ise);
        }
        this.issueRedirect(request, response, redirectUrl);
        return false;
    }

    protected void doLogout(HttpServletRequest request, HttpServletResponse response) {
    }
}

