package com.ejianc.framework.auth.session;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;

/**
 * 用户登录信息
 * 
 * @author guominga
 * @date 2019年4月15日
 */
public class UserContext implements Serializable {

	public static final String SESSION_PREFIX = "ICOP_SESSION_USER:";
	private static final long serialVersionUID = 6176124873649049051L;

	/**
	 * 当前时间
	 */
	private String currentTs;

	/**
	 * 皮肤
	 */
	private String userSkin;

	/**
	 * 用户类型
	 */
	private String userType;

	/**
	 * 用户账号
	 */
	private String userCode;

	/**
	 * 用户姓名
	 */
	private String userName;

	/**
	 * 用户手机号
	 */
	private String userMobile;

	/**
	 * 用户头像
	 */
	private String userAvator;

	/**
	 * 当前组织ID
	 */
	private Long orgId;

	/**
	 * 组织编号
	 */
	private String orgCode;

	/**
	 * 组织名称
	 */
	private String orgName;

	/**
	 * 组织类型
	 */
	private Integer orgType;

	/**
	 * 是否有孩子
	 */
	private Boolean isParent;

	/**
	 * 部门ID
	 */
	private Long deptId;

	/**
	 * 部门编号
	 */
	private String deptCode;

	/**
	 * 部门名称
	 */
	private String deptName;

	/**
	 * 企业名称
	 */
	private String enterpriseName;

	/**
	 * 入驻客户类型
	 */
	private String enterpriseType;

	private String logoCss;

	/**
	 * log
	 */
	private String logoPath;

	private String smallLogoPath;// 企业logo(小)
	/**
	 * 员工ID
	 */
	private Long employeeId;

	/**
	 * 员工姓名
	 */
	private String employeeName;

	/**
	 * 企业微信Id
	 */
	private String wxeeId;

	/**
	 * 微信ID
	 */
	private String weixinId;

	/**
	 * 钉钉ID
	 */
	private String ddId;

	/**
	 * 第三方应用绑定用户的键值
	 */
	private String openId;

	/**
	 * 根据应用鉴权的组织id，以逗号分割
	 */
	private String authOrgIds;

	/**** usercontext cookie ***/
	private Long tenantid;
	private String token;
	private String u_logints;
	private String u_usercode;
	private String u_locale;
	private Long userId;

	// 上下文扩展信息
	private JSONObject ext;

	private String customerChannel; // 客户渠道 ： 自有去掉， 企业微信，钉钉

	private String firstLoginFlag;

	public String getCurrentTs() {
		return currentTs;
	}

	public void setCurrentTs(String currentTs) {
		this.currentTs = currentTs;
	}

	public String getUserSkin() {
		return userSkin;
	}

	public void setUserSkin(String userSkin) {
		this.userSkin = userSkin;
	}

	public String getUserType() {
		return userType;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserMobile() {
		return userMobile;
	}

	public void setUserMobile(String userMobile) {
		this.userMobile = userMobile;
	}

	public String getUserAvator() {
		return userAvator;
	}

	public void setUserAvator(String userAvator) {
		this.userAvator = userAvator;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Integer getOrgType() {
		return orgType;
	}

	public void setOrgType(Integer orgType) {
		this.orgType = orgType;
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	public String getDeptCode() {
		return deptCode;
	}

	public void setDeptCode(String deptCode) {
		this.deptCode = deptCode;
	}

	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public String getEnterpriseName() {
		return enterpriseName;
	}

	public void setEnterpriseName(String enterpriseName) {
		this.enterpriseName = enterpriseName;
	}

	public String getEnterpriseType() {
		return enterpriseType;
	}

	public void setEnterpriseType(String enterpriseType) {
		this.enterpriseType = enterpriseType;
	}

	public String getLogoCss() {
		return logoCss;
	}

	public void setLogoCss(String logoCss) {
		this.logoCss = logoCss;
	}

	public String getLogoPath() {
		return logoPath;
	}

	public void setLogoPath(String logoPath) {
		this.logoPath = logoPath;
	}

	public String getSmallLogoPath() {
		return smallLogoPath;
	}

	public void setSmallLogoPath(String smallLogoPath) {
		this.smallLogoPath = smallLogoPath;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public Long getTenantid() {
		return tenantid;
	}

	public void setTenantid(Long tenantid) {
		this.tenantid = tenantid;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getU_logints() {
		return u_logints;
	}

	public void setU_logints(String u_logints) {
		this.u_logints = u_logints;
	}

	public String getU_usercode() {
		return u_usercode;
	}

	public void setU_usercode(String u_usercode) {
		this.u_usercode = u_usercode;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getUserCode() {
		return userCode;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	public Boolean getIsParent() {
		return isParent;
	}

	public void setIsParent(Boolean isParent) {
		this.isParent = isParent;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public String getWxeeId() {
		return wxeeId;
	}

	public void setWxeeId(String wxeeId) {
		this.wxeeId = wxeeId;
	}

	public String getWeixinId() {
		return weixinId;
	}

	public void setWeixinId(String weixinId) {
		this.weixinId = weixinId;
	}

	public String getDdId() {
		return ddId;
	}

	public void setDdId(String ddId) {
		this.ddId = ddId;
	}

	public String getOpenId() {
		return openId;
	}

	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getU_locale() {
		return u_locale;
	}

	public void setU_locale(String u_locale) {
		this.u_locale = u_locale;
	}

	public JSONObject getExt() {
		return ext;
	}

	public void setExt(JSONObject ext) {
		this.ext = ext;
	}

	public String getCustomerChannel() {
		return customerChannel;
	}

	public void setCustomerChannel(String customerChannel) {
		this.customerChannel = customerChannel;
	}

	public String getFirstLoginFlag() {
		return firstLoginFlag;
	}

	public void setFirstLoginFlag(String firstLoginFlag) {
		this.firstLoginFlag = firstLoginFlag;
	}

	public static UserContext copy(UserContext source, UserContext target) {
		if (StringUtils.isNotBlank(source.getUserSkin())) {
			target.setUserSkin(source.getUserSkin());
		}
		if (StringUtils.isNotBlank(source.getUserType())) {
			target.setUserType(source.getUserType());
		}
		if (StringUtils.isNotBlank(source.getUserName())) {
			target.setUserName(source.getUserName());
		}
		if (StringUtils.isNotBlank(source.getUserAvator())) {
			target.setUserAvator(source.getUserAvator());
		}
		if (StringUtils.isNotBlank(source.getUserCode())) {
			target.setUserCode(source.getUserCode());
		}
		if (StringUtils.isNotBlank(source.getUserMobile())) {
			target.setUserMobile(source.getUserMobile());
		}
		if (source.getOrgId() != null) {
			target.setOrgId(source.getOrgId());
		}
		if (StringUtils.isNotBlank(source.getOrgCode())) {
			target.setOrgCode(source.getOrgCode());
		}
		if (StringUtils.isNotBlank(source.getOrgName())) {
			target.setOrgName(source.getOrgName());
		}
		if (source.getOrgType() != null) {
			target.setOrgType(source.getOrgType());
		}
		if (source.getIsParent() != null) {
			target.setIsParent(source.getIsParent());
		}
		if (source.getDeptId() != null) {
			target.setDeptId(source.getDeptId());
		}
		if (StringUtils.isNotBlank(source.getDeptCode())) {
			target.setDeptCode(source.getDeptCode());
		}
		if (StringUtils.isNotBlank(source.getDeptName())) {
			target.setDeptName(source.getDeptName());
		}
		if (StringUtils.isNotBlank(source.getEnterpriseName())) {
			target.setEnterpriseName(source.getEnterpriseName());
		}
		if(StringUtils.isNotBlank(source.getEnterpriseType())) {
			target.setEnterpriseType(source.getEnterpriseType());
		}
		if (StringUtils.isNotBlank(source.getLogoCss())) {
			target.setLogoCss(source.getLogoCss());
		}
		if (StringUtils.isNotBlank(source.getLogoPath())) {
			target.setLogoPath(source.getLogoPath());
		}
		if (source.getEmployeeId() != null) {
			target.setEmployeeId(source.getEmployeeId());
		}
		if (StringUtils.isNotBlank(source.getEmployeeName())) {
			target.setEmployeeName(source.getEmployeeName());
		}
		if (StringUtils.isNotBlank(source.getU_locale())) {
			target.setU_locale(source.getU_locale());
		}
		if (StringUtils.isNotBlank(source.getCustomerChannel())) {
			target.setCustomerChannel(source.getCustomerChannel());
		}
		if (StringUtils.isNotBlank(source.getFirstLoginFlag())) {
			target.setFirstLoginFlag(source.getFirstLoginFlag());
		}
		if (StringUtils.isNotBlank(source.getWeixinId())) {
			target.setWeixinId(source.getWeixinId());
		}
		if (StringUtils.isNotBlank(source.getWxeeId())) {
			target.setWxeeId(source.getWxeeId());
		}
		if (StringUtils.isNotBlank(source.getSmallLogoPath())) {
			target.setSmallLogoPath(source.getSmallLogoPath());
		}
		return target;
	}

	public String getAuthOrgIds() {
		return authOrgIds;
	}

	public void setAuthOrgIds(String authOrgIds) {
		this.authOrgIds = authOrgIds;
	}

	private static SessionManager sessionManager = SpringContextTools.getBean(SessionManager.class);

	public static UserContext getUserContext() {
		String sid = SESSION_PREFIX + InvocationInfoProxy.getUserid();
		String userContextStr = (String) sessionManager.getSessionCacheAttribute(sid, InvocationInfoProxy.getToken());
		UserContext userContext = JSONObject.parseObject(userContextStr, UserContext.class);
		return userContext;
	}

	@Override
	public String toString() {
		return "UserContext [currentTs=" + currentTs + ", userSkin=" + userSkin + ", userType=" + userType
				+ ", userCode=" + userCode + ", userName=" + userName + ", userAvator=" + userAvator + ", userMobile="
				+ userMobile + ",orgId=" + orgId + ", orgCode=" + orgCode + ", orgName=" + orgName + ", orgType="
				+ orgType + ", isParent=" + isParent + ", deptId=" + deptId + ", deptCode=" + deptCode + ", deptName="
				+ deptName + ", enterpriseName=" + enterpriseName + ", enterpriseType=" + enterpriseType + ", logoPath=" + logoPath
				+ ", smallLogoPath=" + smallLogoPath + ", employeeId="
				+ employeeId + ", employeeName=" + employeeName + ", wxeeId=" + wxeeId + ", weixinId=" + weixinId
				+ ", openId=" + openId + ", tenantid=" + tenantid + ", token=" + token + ", u_logints=" + u_logints
				+ ", u_usercode=" + u_usercode + ", u_locale=" + u_locale + ", userId=" + userId + ", authOrgIds="
				+ authOrgIds + "]";
	}

}
