package com.ejianc.framework.auth.shiro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

import com.alibaba.fastjson.JSON;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.token.ITokenProcessor;
import com.ejianc.framework.auth.token.TokenFactory;
import com.ejianc.framework.auth.token.TokenParameter;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;

public class StatelessRealm extends AuthorizingRealm {

	private static final Logger logger = LoggerFactory.getLogger(StatelessRealm.class);
	
	private final String STATELESSREALM_USER_AUTHENTICATE="statelessrealm_user_authenticate:";
	
	@Autowired
	TokenFactory tokenFactory;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private EnvironmentTools environmentTools;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Override
	public boolean supports(AuthenticationToken token) {
		// 仅支持StatelessToken类型的Token
		return token instanceof StatelessToken;
	}

	@Override
	protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
		SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
		List<String> roles = new ArrayList<String>();
		info.addRoles(roles);
		return info;
	}

	@Override
	protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken atoken) throws AuthenticationException {
		StatelessToken token = (StatelessToken) atoken;
		TokenParameter tp = token.getTp();
		String uname = (String) token.getPrincipal();
		ITokenProcessor tokenProcessor = token.getTokenProcessor();
		String tokenStr = tokenProcessor.generateToken(tp);
		if (tokenStr == null || !sessionManager.validateOnlineSession(uname, tokenStr)) {
			//session失效，  向webpush发送一条消息
			String baseHost = environmentTools.getBaseHost();
			if(StringUtils.isNotBlank(baseHost) && StringUtils.isNotBlank(tokenStr)) {
				Object sendObj = redisTemplate.opsForValue().get(STATELESSREALM_USER_AUTHENTICATE+tokenStr);
				if(sendObj == null) {
					Thread logoutThread = new Thread(new Runnable() {
						@Override
						public void run() {
							String url = baseHost+"ejc-webpush/event/send";
							Map<String,Object> paramMap = new HashMap<>();
							paramMap.put("token", tokenStr);
							paramMap.put("type", "logout");
							paramMap.put("value", "logout");
							try {
								logger.info("url："+url);
								logger.info("参数："+JSON.toJSONString(paramMap));
								HttpTookit.postByJson(url, JSON.toJSONString(paramMap));
							} catch (Exception e) {
								logger.error("向webpush发送退出事件失败；Msg："+e.getMessage());
							}
						}
					});
					logoutThread.start();
					
					try {
						redisTemplate.opsForValue().set(STATELESSREALM_USER_AUTHENTICATE+tokenStr, "true", 5, TimeUnit.SECONDS);
					}catch(Exception e) {}
				}
			}
			logger.error("User [{}] authenticate fail in System, maybe session timeout!", uname);
			throw new AuthenticationException("User " + uname + " authenticate fail in System");
		}
		
		return new SimpleAuthenticationInfo(uname, tokenStr, getName());
	}
}