/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="enroll")
public class EnrollBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IInfoTrackService infoTrackService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        InfoTrackEntity info;
        EnrollEntity entity = (EnrollEntity)((Object)this.enrollService.getById(billId));
        Integer sourceType = entity.getSourceType();
        Long sourceId = entity.getSourceId();
        String engineeringName = entity.getEngineeringName();
        if (BidCommonConsts.NO.equals(sourceType) && sourceId != null && null != (info = (InfoTrackEntity)((Object)this.infoTrackService.getById(sourceId)))) {
            String _engineeringName = info.getEngineeringName();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)info.getId());
            updateWrapper.eq(InfoTrackEntity::getFollowState, (Object)BidStateEnum.YI_BAO_MING.getCode());
            if (!engineeringName.equals(_engineeringName)) {
                updateWrapper.eq(InfoTrackEntity::getHisEngineeringName, (Object)_engineeringName);
                updateWrapper.eq(InfoTrackEntity::getEngineeringName, (Object)engineeringName);
            }
            this.infoTrackService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

