package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.vo.RecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.RecordMapper;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.service.IRecordService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 投标记录
 *
 * @author generator
 */
@Service("recordService")
public class RecordServiceImpl extends BaseServiceImpl<RecordMapper, RecordEntity> implements IRecordService {

    @Override
    public RecordVO saveRecord(BidStageEnum stageEnum, Long billId, String engineeringCode) {
        RecordVO recordVO = new RecordVO(billId, engineeringCode, stageEnum.getCode(), stageEnum.getName(), new Date());
        this.saveOrUpdate(BeanMapper.map(recordVO, RecordEntity.class));
        return recordVO;
    }

    /**
     * @param engineeringCode 工程编码
     * @description: 获取记录
     * @return: com.ejianc.business.bid.vo.RecordVO
     * @author songlx
     * @date: 2021/11/18
     */
    @Override
    public List<RecordVO> getRecord(String engineeringCode) {
        List<RecordVO> recordVOS = new ArrayList<>();
        if (StringUtils.isNotEmpty(engineeringCode)) {
            LambdaQueryWrapper<RecordEntity> lambd = Wrappers.lambdaQuery();
            lambd.eq(RecordEntity::getEngineeringCode, engineeringCode);
            lambd.orderByAsc(RecordEntity::getCreateTime);

            List<RecordEntity> list = this.list(lambd);

            if (CollectionUtils.isNotEmpty(list)) {
                Map<Integer, List<RecordEntity>> map = list.stream().collect(Collectors.groupingBy(RecordEntity::getBidStage));
                for (Map.Entry<Integer, List<RecordEntity>> m : map.entrySet()) {
                    List<RecordEntity> value = m.getValue();
                    recordVOS.add(new RecordVO(m.getKey(), BeanMapper.mapList(value, RecordVO.class)));
                }
            }
        }

        return recordVOS;
    }
}
