package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.consts.BiddingFormEnum;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bid.bean.PrequaliFicationEntity;
import com.ejianc.business.bid.service.IPrequaliFicationService;
import com.ejianc.business.bid.vo.PrequaliFicationVO;

/**
 * 资格预审
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("prequaliFication")
@Api(value = "资格预审", tags = {"资格预审"})
public class PrequaliFicationController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRecordService recordService;

    private static final String BILL_CODE = "BID_PREQUALIFICATION";//此处需要根据实际修改

    @Autowired
    private IPrequaliFicationService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PrequaliFicationVO> saveOrUpdate(@RequestBody PrequaliFicationVO saveorUpdateVO) {
        PrequaliFicationEntity entity = BeanMapper.map(saveorUpdateVO, PrequaliFicationEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        PrequaliFicationVO vo = BeanMapper.map(entity, PrequaliFicationVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PrequaliFicationVO> queryDetail(Long id) {
        PrequaliFicationEntity entity = service.selectById(id);
        PrequaliFicationVO vo = BeanMapper.map(entity, PrequaliFicationVO.class);
        vo.setRecords(recordService.getRecord(vo.getEngineeringCode()));
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param enrollId
     */
    @RequestMapping(value = "/queryByEnrollId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PrequaliFicationVO> queryByEnrollId(Long enrollId) {
        PrequaliFicationEntity entity = service.selectByEnrollId(enrollId);
        if(null == entity){
            return CommonResponse.error("未查询到数据");
        }
        PrequaliFicationVO vo = BeanMapper.map(entity, PrequaliFicationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param enrollId
     */
    @RequestMapping(value = "/checkSave", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse checkSave(Long enrollId) {
        boolean b = service.checkSave(enrollId);
        if(b){
            return CommonResponse.success();
        }
        return CommonResponse.error("");
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrequaliFicationVO> vos) {
        service.removeByIds(vos.stream().map(PrequaliFicationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PrequaliFicationVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<PrequaliFicationEntity> page = service.queryPage(param,false);
        IPage<PrequaliFicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrequaliFicationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<PrequaliFicationEntity> list = service.queryList(param);
        List<PrequaliFicationVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, PrequaliFicationVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("PrequaliFication-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPrequaliFicationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PrequaliFicationVO>> refPrequaliFicationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PrequaliFicationEntity> page = service.queryPage(param,false);
        IPage<PrequaliFicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrequaliFicationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
