/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="summary")
public class SummaryBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRecordService recordService;
    @Autowired
    private ISummaryService summaryService;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IInfoTrackService trackService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SummaryEntity summaryEntity = (SummaryEntity)((Object)this.summaryService.selectById(billId));
        if (summaryEntity != null && summaryEntity.getBidResult() != null) {
            LambdaUpdateWrapper updateWrapper;
            if (summaryEntity.getBidResult() == 0) {
                this.recordService.saveRecord(BidStageEnum.TOU_BIAO_ZONG_JIE_ZHONG_BIAO, billId, summaryEntity.getEngineeringCode());
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)summaryEntity.getEnrollId());
                updateWrapper.set(EnrollEntity::getBidStage, (Object)BidStageEnum.TOU_BIAO_ZONG_JIE_ZHONG_BIAO.getCode());
                updateWrapper.set(EnrollEntity::getBidState, (Object)BidStateEnum.YI_JIE_SHU.getCode());
                this.enrollService.update((Wrapper)updateWrapper);
            } else {
                this.recordService.saveRecord(BidStageEnum.TOU_BIAO_ZONG_JIE_WEI_ZHONG_BIAO, billId, summaryEntity.getEngineeringCode());
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)summaryEntity.getEnrollId());
                updateWrapper.set(EnrollEntity::getBidStage, (Object)BidStageEnum.TOU_BIAO_ZONG_JIE_ZHONG_BIAO.getCode());
                updateWrapper.set(EnrollEntity::getBidState, (Object)BidStateEnum.YI_JIE_SHU.getCode());
                this.enrollService.update((Wrapper)updateWrapper);
            }
            Long enrollId = summaryEntity.getEnrollId();
            EnrollEntity enrollEntity = (EnrollEntity)((Object)this.enrollService.selectById(enrollId));
            if (enrollEntity.getSourceId() != null) {
                LambdaUpdateWrapper updateWrapper2 = new LambdaUpdateWrapper();
                updateWrapper2.eq(BaseEntity::getId, (Object)enrollEntity.getSourceId());
                updateWrapper2.set(InfoTrackEntity::getFollowState, (Object)BidStateEnum.YI_JIE_SHU.getCode());
                this.trackService.update((Wrapper)updateWrapper2);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

