package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.PrequaliFicationEntity;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IPrequaliFicationService;
import com.ejianc.business.bid.service.IRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("prequaliFication") 
public class PrequaliFicationBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IPrequaliFicationService prequaliFicationService;
	@Autowired
	private IRecordService recordService;
	@Autowired
	private IEnrollService enrollService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("终审完成，开始回写状态，billId:"+billId);
		PrequaliFicationEntity prequaliFicationEntity = prequaliFicationService.selectById(billId);
		if (prequaliFicationEntity != null) {
			recordService.saveRecord(BidStageEnum.ZI_GE_YU_SHEN, billId, prequaliFicationEntity.getEngineeringCode());
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, prequaliFicationEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.ZI_GE_YU_SHEN.getCode());
			enrollService.update(updateWrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
