/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.consts.BiddingFormEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"enroll"})
@Api(value="\u6295\u6807\u62a5\u540d", tags={"\u6295\u6807\u62a5\u540d"})
public class EnrollController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_ENGINEERING_CODE";
    @Autowired
    private IEnrollService service;
    @Autowired
    private IInfoTrackService infoTrackService;
    @Autowired
    private IRecordService recordService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EnrollVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody EnrollVO saveorUpdateVO) {
        EnrollEntity entity = (EnrollEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, EnrollEntity.class));
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        EnrollVO vo = (EnrollVO)BeanMapper.map((Object)((Object)entity), EnrollVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u53c2\u7167\u4fe1\u606f\u8ddf\u8e2a\u65b0\u589e")
    @RequestMapping(value={"/addByInfotrack"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EnrollVO> addByInfotrack(@RequestParam Long id) {
        InfoTrackEntity infoTrack = (InfoTrackEntity)((Object)this.infoTrackService.selectById(id));
        EnrollEntity vo = new EnrollEntity();
        if (infoTrack != null) {
            vo.setBillCode(infoTrack.getBillCode());
            vo.setEngineeringName(infoTrack.getEngineeringName());
            vo.setInfoSource(infoTrack.getInfoSource());
            vo.setInfoSourceName(infoTrack.getInfoSourceName());
            vo.setFollowPerson(infoTrack.getUnitDirector());
            vo.setFollowPersonName(infoTrack.getUnitDirectorName());
            vo.setFollowPersonPhone(infoTrack.getUnitDirectorPhone());
            vo.setBidState(BidStateEnum.JIN_XING_ZHONG.getCode());
            vo.setProjectManager(infoTrack.getProjectBidManage());
            vo.setProjectManagerName(infoTrack.getProjectBidManageName());
            vo.setProjectManagerPhone(infoTrack.getProjectBidManagePhone());
            vo.setIsPrecheck(BidCommonConsts.NO);
            vo.setAddress(infoTrack.getAddress());
            vo.setArea(infoTrack.getArea());
            vo.setProvince(infoTrack.getProvince());
            vo.setCity(infoTrack.getCity());
            vo.setRegion(infoTrack.getRegion());
            vo.setIsGive(BidCommonConsts.NO);
            vo.setConstructionUnit(infoTrack.getConstructionUnit());
            vo.setConstructionUnitName(infoTrack.getConstructionUnitName());
            vo.setOwnerClient(infoTrack.getOwnerEntrust());
            vo.setOwnerClientPhone(infoTrack.getOwnerEntrustPhone());
            vo.setFundsSource(infoTrack.getFundsSource());
            vo.setFundsSourceName(infoTrack.getFundsSourceName());
            vo.setBiddingForm(infoTrack.getBiddingForm());
            vo.setBidScope(infoTrack.getBidRange());
            vo.setEngineeringType(infoTrack.getEngineeringType());
            vo.setEngineeringTypeName(infoTrack.getEngineeringTypeName());
            vo.setPlanDay(infoTrack.getPlanDuration());
            vo.setCostTotal(infoTrack.getTheInvestmentAmount());
            vo.setRemark(infoTrack.getRemark());
            vo.setBidStage(BidStageEnum.TOU_BIAO_BAO_MING.getCode());
            vo.setBidAgentOrg(infoTrack.getBiddingAgency());
            vo.setIsGive(BidCommonConsts.NO);
            vo.setIsStop(BidCommonConsts.NO);
            vo.setSourceType(BidCommonConsts.NO);
            vo.setSourceId(id);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)vo), EnrollVO.class));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EnrollVO> queryDetail(@RequestParam Long id) {
        EnrollEntity entity = (EnrollEntity)((Object)this.service.selectById(id));
        EnrollVO vo = (EnrollVO)BeanMapper.map((Object)((Object)entity), EnrollVO.class);
        vo.setRecords(this.recordService.getRecord(vo.getBillCode()));
        if (null != vo) {
            vo.setBiddingFormName(BiddingFormEnum.getNameByCode((Integer)vo.getBiddingForm()));
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setBidStageName(BidStageEnum.getNameByCode((Integer)vo.getBidStage()));
            vo.setBidStateName(BidStateEnum.getNameByCode((Integer)vo.getBidState()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EnrollVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EnrollVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("billCode", "engineeringName", "bidOrgName", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EnrollVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setFuzzyFields(Arrays.asList("billCode", "engineeringName", "bidOrgName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, EnrollVO.class);
            voList.forEach(vo -> {
                vo.setBiddingFormName(BiddingFormEnum.getNameByCode((Integer)vo.getBiddingForm()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setBidStageName(BidStageEnum.getNameByCode((Integer)vo.getBidStage()));
                vo.setBidStateName(BidStateEnum.getNameByCode((Integer)vo.getBidState()));
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Enroll-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refEnrollData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EnrollVO>> refEnrollData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("billCode", "engineeringName", "bidOrgName", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("isStop", new Parameter("eq", (Object)BidCommonConsts.NO));
        param.getParams().put("bidState", new Parameter("ne", (Object)BidStateEnum.YI_JIE_SHU));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("bidOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"isPrecheck") != null) {
                param.getParams().put("isPrecheck", new Parameter("eq", _con.get((Object)"isPrecheck")));
            }
            if (_con.get((Object)"bidState") != null) {
                param.getParams().put("bidState", new Parameter("in", _con.get((Object)"bidState")));
            }
            if (_con.get((Object)"isPreChecked") != null) {
                param.getParams().put("isPreChecked", new Parameter("eq", _con.get((Object)"isPreChecked")));
            }
            if (_con.get((Object)"isBidChecked") != null) {
                param.getParams().put("isBidChecked", new Parameter("eq", _con.get((Object)"isBidChecked")));
            }
            if (_con.get((Object)"isBidddingChecked") != null) {
                param.getParams().put("isBidddingChecked", new Parameter("eq", _con.get((Object)"isBidddingChecked")));
            }
            if (_con.get((Object)"isSummary") != null) {
                Page page = new Page();
                QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
                wrapper.apply("(is_bid_checked = 1 or (is_biddding_checked = 1 and is_precheck = 1 and is_give = 1))", new Object[0]);
                IPage summarypage = this.service.page((IPage)page, (Wrapper)wrapper);
                Page pageData = new Page(summarypage.getCurrent(), summarypage.getSize(), summarypage.getTotal());
                List enrollVOS = BeanMapper.mapList((Iterable)page.getRecords(), EnrollVO.class);
                for (EnrollVO enrollVO : enrollVOS) {
                    enrollVO.setBidStateName(BidStateEnum.getNameByCode((Integer)enrollVO.getBidState()));
                    enrollVO.setBiddingFormName(BiddingFormEnum.getNameByCode((Integer)enrollVO.getBiddingForm()));
                }
                pageData.setRecords(enrollVOS);
                return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List enrollVOS = BeanMapper.mapList((Iterable)page.getRecords(), EnrollVO.class);
        for (EnrollVO enrollVO : enrollVOS) {
            enrollVO.setBidStateName(BidStateEnum.getNameByCode((Integer)enrollVO.getBidState()));
            enrollVO.setBiddingFormName(BiddingFormEnum.getNameByCode((Integer)enrollVO.getBiddingForm()));
        }
        pageData.setRecords(enrollVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

