/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.BiddingFileReviewEntity;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.PrequaliFicationEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.service.IBiddingFileReviewService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IPrequaliFicationService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prequaliFication")
public class PrequaliFicationBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8d44\u683c\u9884\u5ba1\uff0c\u63d0\u4ea4\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u9884\u5ba1\u6570\u636e\u63d0\u4ea4\u56de\u8c03\uff0c\u5f00\u59cb\u56de\u5199\u72b6\u6001,billId:" + billId);
        PrequaliFicationEntity prequaliFicationEntity = (PrequaliFicationEntity)((Object)this.prequaliFicationService.selectById(billId));
        if (null != prequaliFicationEntity && "\u901a\u8fc7".equals(prequaliFicationEntity.getEstimatedExamineResultName())) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)prequaliFicationEntity.getEnrollId());
            updateWrapper.set(EnrollEntity::getIsPreChecked, (Object)BidCommonConsts.YES);
            this.enrollService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8d44\u683c\u9884\u5ba1\uff0c\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03\uff0cbillId" + billId);
        PrequaliFicationEntity prequaliFicationEntity = (PrequaliFicationEntity)((Object)this.prequaliFicationService.selectById(billId));
        if (null != prequaliFicationEntity) {
            BiddingFileReviewEntity biddingFileReviewEntity = this.biddingFileReviewService.selectByEnrollId(prequaliFicationEntity.getEnrollId());
            if (biddingFileReviewEntity != null) {
                return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u5355\u636e\uff08\u62db\u6807\u6587\u4ef6\u8bc4\u5ba1\uff09\u5f15\u7528");
            }
            if ("\u901a\u8fc7".equals(prequaliFicationEntity.getEstimatedExamineResultName())) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)prequaliFicationEntity.getEnrollId());
                updateWrapper.set(EnrollEntity::getIsPreChecked, (Object)BidCommonConsts.NO);
                this.enrollService.update((Wrapper)updateWrapper);
            }
        }
        if (billId != null) {
            this.recordService.saveRecord(BidStageEnum.TOU_BIAO_BAO_MING, billId, prequaliFicationEntity.getEngineeringCode());
            LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
            updateWrapper.eq(RecordEntity::getBillId, (Object)billId);
            this.recordService.remove((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8d44\u683c\u9884\u5ba1\uff0c\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u540e\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5b8c\u6210\uff0c\u5f00\u59cb\u56de\u5199\u72b6\u6001\uff0cbillId:" + billId);
        PrequaliFicationEntity prequaliFicationEntity = (PrequaliFicationEntity)((Object)this.prequaliFicationService.selectById(billId));
        if (prequaliFicationEntity != null) {
            this.recordService.saveRecord(BidStageEnum.ZI_GE_YU_SHEN, billId, prequaliFicationEntity.getEngineeringCode());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)prequaliFicationEntity.getEnrollId());
            updateWrapper.set(EnrollEntity::getBidStage, (Object)BidStageEnum.ZI_GE_YU_SHEN.getCode());
            if ("\u901a\u8fc7".equals(prequaliFicationEntity.getEstimatedExamineResultName())) {
                updateWrapper.set(EnrollEntity::getIsPreChecked, (Object)BidCommonConsts.YES);
            }
            this.enrollService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u9884\u5ba1\u6570\u636e\u64a4\u56de\u56de\u8c03\uff0c\u5f00\u59cb\u56de\u5199\u72b6\u6001,billId:" + billId);
        PrequaliFicationEntity prequaliFicationEntity = (PrequaliFicationEntity)((Object)this.prequaliFicationService.selectById(billId));
        if (null != prequaliFicationEntity) {
            BiddingFileReviewEntity biddingFileReviewEntity = this.biddingFileReviewService.selectByEnrollId(prequaliFicationEntity.getEnrollId());
            if (biddingFileReviewEntity != null) {
                return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u5355\u636e\uff08\u62db\u6807\u6587\u4ef6\u8bc4\u5ba1\uff09\u5f15\u7528");
            }
            if ("\u901a\u8fc7".equals(prequaliFicationEntity.getEstimatedExamineResultName())) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)prequaliFicationEntity.getEnrollId());
                updateWrapper.set(EnrollEntity::getIsPreChecked, (Object)BidCommonConsts.NO);
                this.enrollService.update((Wrapper)updateWrapper);
            }
        }
        if (billId != null) {
            this.recordService.saveRecord(BidStageEnum.TOU_BIAO_BAO_MING, billId, prequaliFicationEntity.getEngineeringCode());
            LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
            updateWrapper.eq(RecordEntity::getBillId, (Object)billId);
            this.recordService.remove((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

