/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.StopApplyEntity;
import com.ejianc.business.bid.consts.BidBillTypeEnum;
import com.ejianc.business.bid.mapper.StopApplyMapper;
import com.ejianc.business.bid.service.IBidFileReviewService;
import com.ejianc.business.bid.service.IBiddingFileReviewService;
import com.ejianc.business.bid.service.IPrequaliFicationService;
import com.ejianc.business.bid.service.IStopApplyService;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="stopApplyService")
public class StopApplyServiceImpl
extends BaseServiceImpl<StopApplyMapper, StopApplyEntity>
implements IStopApplyService {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBpmApi iBpmApi;
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    @Autowired
    private ISummaryService summaryService;

    @Override
    public void stopApproval(Long enrollId) {
        if (enrollId != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            param.getParams().put("enrollId", new Parameter("eq", (Object)enrollId));
            param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode())));
            List prequaliFicationList = this.prequaliFicationService.queryList(param, false);
            prequaliFicationList.forEach(item -> {
                String id = item.getId().toString();
                this.iBpmApi.stopProcess(id, BidBillTypeEnum.ZI_GE_YU_SHEN.getCode());
            });
            List biddingFileReviewList = this.biddingFileReviewService.queryList(param, false);
            biddingFileReviewList.forEach(item -> {
                String id = item.getId().toString();
                this.iBpmApi.stopProcess(id, BidBillTypeEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode());
            });
            List bidFileReviewList = this.bidFileReviewService.queryList(param, false);
            bidFileReviewList.forEach(item -> {
                String id = item.getId().toString();
                this.iBpmApi.stopProcess(id, BidBillTypeEnum.TOU_BIAO_WEN_JIAN_PING_SHEN.getCode());
            });
            List summaryList = this.summaryService.queryList(param, false);
            summaryList.forEach(item -> {
                String id = item.getId().toString();
                this.iBpmApi.stopProcess(id, BidBillTypeEnum.TOU_BIAO_ZONG_JIE.getCode());
            });
        }
    }
}

