package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("enroll")
public class EnrollBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IEnrollService enrollService;

    @Autowired
    private IInfoTrackService infoTrackService;

    @Autowired
    private IRecordService recordService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //审批完后需要 回写
        EnrollEntity entity = enrollService.getById(billId);
        Integer sourceType = entity.getSourceType();
        Long sourceId = entity.getSourceId();
        String engineeringName = entity.getEngineeringName();
        //来源是信息跟踪 更新报名状态和历史工程名
        if (BidCommonConsts.NO.equals(sourceType) && sourceId != null) {
            InfoTrackEntity info = infoTrackService.getById(sourceId);
            if (null != info) {
                String _engineeringName = info.getEngineeringName();
                LambdaUpdateWrapper<InfoTrackEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(InfoTrackEntity::getId, info.getId());
                updateWrapper.set(InfoTrackEntity::getFollowState, BidStateEnum.YI_BAO_MING.getCode());
                if (!engineeringName.equals(_engineeringName)) {
                    updateWrapper.set(InfoTrackEntity::getHisEngineeringName, _engineeringName);
                    updateWrapper.set(InfoTrackEntity::getEngineeringName, engineeringName);
                }
                infoTrackService.update(updateWrapper);
            }
        }

        recordService.saveRecord(BidStageEnum.TOU_BIAO_BAO_MING, billId, entity.getBillCode());

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //是否被其他单据引用
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        //单据未被下游单据引用
        if (res.isSuccess()) {
            //删除记录
            LambdaQueryWrapper<RecordEntity> updateWrapper = new LambdaQueryWrapper<>();
            updateWrapper.eq(RecordEntity::getBillId, billId);
            recordService.remove(updateWrapper);

            EnrollEntity entity = enrollService.getById(billId);
            Integer sourceType = entity.getSourceType();
            Long sourceId = entity.getSourceId();
            //来源是信息跟踪 更新报名状态和历史工程名
            if (BidCommonConsts.NO.equals(sourceType) && sourceId != null) {
                InfoTrackEntity info = infoTrackService.getById(sourceId);
                if (null != info) {
                    LambdaUpdateWrapper<InfoTrackEntity> wrapper = new LambdaUpdateWrapper<>();
                    wrapper.eq(InfoTrackEntity::getId, info.getId());
                    wrapper.eq(InfoTrackEntity::getFollowState, BidStateEnum.YI_BAO_MING.getCode());
                    wrapper.set(InfoTrackEntity::getFollowState, BidStateEnum.GEN_ZONG_ZHONG.getCode());
                    infoTrackService.update(wrapper);
                }
            }
            return CommonResponse.success();
        } else {
            return CommonResponse.error(res.getMsg());
        }


    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }


}
