package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.InfoTrackStopEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IInfoTrackStopService;
import com.ejianc.business.bid.service.IRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("infoTrackStop") 
public class InfoTrackStopBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IInfoTrackService infoTrackService;
	@Autowired
	private IInfoTrackStopService infoTrackStopService;
	@Autowired
	private IRecordService recordService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		// 中止报名信息跟踪
		if(billId != null){
			InfoTrackStopEntity infoTrackStop = infoTrackStopService.selectById(billId);
			if(infoTrackStop != null){
				LambdaUpdateWrapper<InfoTrackEntity> wrapper = new LambdaUpdateWrapper<>();
				wrapper.eq(InfoTrackEntity::getId,infoTrackStop.getInfoTrackId());
				wrapper.set(InfoTrackEntity::getFollowState, BidStateEnum.YI_JIE_SHU.getCode());
				wrapper.set(InfoTrackEntity::getIsStop, BidCommonConsts.YES);
				infoTrackService.update(wrapper);

				recordService.saveRecord(BidStageEnum.TOU_BIAO_XIN_XIN_GEN_ZONG_TING_ZHI,billId,infoTrackStop.getBillCode());
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("投标信息跟踪中止单据无法弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
