package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.StopApplyEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("stopApply") 
public class StopApplyBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IStopApplyService stopApplyService;
	@Autowired
	private IRecordService recordService;
	@Autowired
	private IEnrollService enrollService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		////向记录表里插入投标信息跟踪数据
		if(billId != null){
			StopApplyEntity stopApply = stopApplyService.selectById(billId);
			if(stopApply != null){
				LambdaUpdateWrapper<EnrollEntity> wrapper = new LambdaUpdateWrapper<>();
				//投标停止
				wrapper.eq(EnrollEntity::getId,stopApply.getEnrollId());
				wrapper.set(EnrollEntity::getIsStop, BidCommonConsts.YES);
				wrapper.set(EnrollEntity::getBidStage,BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING.getCode());
				wrapper.set(EnrollEntity::getBidState, BidStateEnum.YI_JIE_SHU.getCode());
				enrollService.update(wrapper);
				//中止该投标报名后续的所有审批中的单据的流程
				new Thread(()->{
					try {
						stopApplyService.stopApproval(stopApply.getEnrollId());
					}catch (Exception e){
						e.printStackTrace();
					}
				}).start();
				//插入记录表数据
				recordService.saveRecord(BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING,billId,stopApply.getBillCode());
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("投标停止申请单据无法弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
