/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.StopApplyEntity;
import com.ejianc.business.bid.consts.BidBillTypeEnum;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IBidFileReviewService;
import com.ejianc.business.bid.service.IBiddingFileReviewService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IPrequaliFicationService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.service.IStopApplyService;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="stopApply")
public class StopApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStopApplyService stopApplyService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IBpmApi iBpmApi;
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    @Autowired
    private ISummaryService summaryService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        StopApplyEntity stopApply;
        if (billId != null && (stopApply = (StopApplyEntity)((Object)this.stopApplyService.selectById(billId))) != null) {
            String authority = this.request.getHeader("authority");
            int taskSize = 5;
            ExecutorService threadPool = Executors.newFixedThreadPool(taskSize);
            try {
                MyTodoAndSubmitTask myTodoAndSubmitCallable = new MyTodoAndSubmitTask(RequestContextHolder.getRequestAttributes(), stopApply.getEnrollId(), authority);
                threadPool.submit(myTodoAndSubmitCallable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                threadPool.shutdown();
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)stopApply.getEnrollId());
            wrapper.set(EnrollEntity::getIsStop, (Object)BidCommonConsts.YES);
            wrapper.set(EnrollEntity::getBidStage, (Object)BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING.getCode());
            wrapper.set(EnrollEntity::getBidState, (Object)BidStateEnum.YI_JIE_SHU.getCode());
            this.enrollService.update((Wrapper)wrapper);
            this.recordService.saveRecord(BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING, billId, stopApply.getEngineeringCode());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u6295\u6807\u505c\u6b62\u7533\u8bf7\u5355\u636e\u65e0\u6cd5\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    class MyTodoAndSubmitTask
    implements Callable<JSONObject> {
        private RequestAttributes context;
        private Long enrollId;
        private String authority;

        public MyTodoAndSubmitTask(RequestAttributes context, Long enrollId, String authority) {
            this.context = context;
            this.enrollId = enrollId;
            this.authority = authority;
        }

        @Override
        public JSONObject call() throws Exception {
            JSONObject resp = new JSONObject();
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            QueryParam param = new QueryParam();
            param.getParams().put("enrollId", new Parameter("eq", (Object)this.enrollId));
            param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode())));
            List prequaliFicationList = StopApplyBpmServiceImpl.this.prequaliFicationService.queryList(param, false);
            prequaliFicationList.forEach(item -> {
                String id = item.getId().toString();
                CommonResponse stringCommonResponse = StopApplyBpmServiceImpl.this.iBpmApi.stopProcess(id, BidBillTypeEnum.ZI_GE_YU_SHEN.getCode());
                StopApplyBpmServiceImpl.this.logger.info("22222222\u7ec8\u8eab\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)stringCommonResponse.toString());
            });
            List biddingFileReviewList = StopApplyBpmServiceImpl.this.biddingFileReviewService.queryList(param, false);
            biddingFileReviewList.forEach(item -> {
                String id = item.getId().toString();
                StopApplyBpmServiceImpl.this.iBpmApi.stopProcess(id, BidBillTypeEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode());
            });
            List bidFileReviewList = StopApplyBpmServiceImpl.this.bidFileReviewService.queryList(param, false);
            bidFileReviewList.forEach(item -> {
                String id = item.getId().toString();
                StopApplyBpmServiceImpl.this.iBpmApi.stopProcess(id, BidBillTypeEnum.TOU_BIAO_WEN_JIAN_PING_SHEN.getCode());
            });
            List summaryList = StopApplyBpmServiceImpl.this.summaryService.queryList(param, false);
            summaryList.forEach(item -> {
                String id = item.getId().toString();
                StopApplyBpmServiceImpl.this.iBpmApi.stopProcess(id, BidBillTypeEnum.TOU_BIAO_ZONG_JIE.getCode());
            });
            return resp;
        }
    }
}

