package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.bid.vo.SummaryVO;

/**
 *   投标总结 
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("summary")
@Api(value = "  投标总结 ", tags = {"  投标总结 "})
public class SummaryController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_SUMMARY_CODE";
    @Autowired
    private ISummaryService service;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SummaryVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SummaryVO saveorUpdateVO) {
    	SummaryEntity entity = BeanMapper.map(saveorUpdateVO, SummaryEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	/**报价形式 0:总价 1:费率 **/
    	if (BidCommonConsts.NO.equals(entity.getQuotationForm())){
            entity.setBiddingControlRate(null);
            entity.setBidQuotationRate(null);
            entity.setControlQuoteLowerRate(null);
        }
    	else{
            entity.setBidMmy(null);
            entity.setBiddingControlMmy(null);
            entity.setQuoteLowerRate(null);
        }
    	service.saveOrUpdate(entity, false);
    	SummaryVO vo = BeanMapper.map(entity, SummaryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SummaryVO> queryDetail(@RequestParam Long id) {
    	SummaryEntity entity = service.selectById(id);
    	SummaryVO vo = BeanMapper.map(entity, SummaryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SummaryVO> vos) {
        service.removeByIds(vos.stream().map(SummaryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SummaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        fuzzyFields.add("bidEvaluationMethod");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<SummaryEntity> page = service.queryPage(param,false);
        IPage<SummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SummaryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        fuzzyFields.add("bidEvaluationMethod");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SummaryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SummaryVO> summaryVoS = BeanMapper.mapList(list, SummaryVO.class);
        Map<String, Object> beans = new HashMap<>(summaryVoS.size());
        for (SummaryVO summaryVO : summaryVoS) {
            summaryVO.setBillStateName(BillStateEnum.getEnumByStateCode(summaryVO.getBillState()).getDescription());
            summaryVO.setBidResultName(summaryVO.getBidResult().equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode())? "已中标":"未中标");
        }
        beans.put("records", summaryVoS);
        ExcelExport.getInstance().export("Summary-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refsummaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SummaryVO>> refsummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }

        IPage<SummaryEntity> page = service.queryPage(param,false);
        IPage<SummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SummaryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
